<?php

namespace App\Http\Controllers\Backend\Dashboard;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\ChartOfAccount;
use App\Models\Customer;
use App\Models\customerLedger;
use App\Models\Employee;
use App\Models\Expense;
use App\Models\LeaveApplication;
use App\Models\Lone;
use App\Models\ProductUse;
use App\Models\Project;
use App\Models\ProjectExpense;
use App\Models\ProjectRequisition;
use App\Models\ProjectReturn;
use App\Models\PurchaseOrder;
use App\Models\PurchaseRequisition;
use App\Models\Purchases;
use App\Models\Sale;
use App\Models\Service;
use App\Models\StockAjdustment;
use App\Models\Supplier;
use App\Models\supplierLedger;
use App\Models\Transection;
use App\Models\Transfer;
use App\Models\User;
use App\Models\UserRole;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = Auth::user();
        // $purchase = Purchases::where('status', 'Active');
        // if ($user->branch_id != null) {
        //     $purchase = $purchase->where('branch_id', $user->branch_id);
        // }
        // $purchase = $purchase->sum('grand_total');

        $purchase =  getUnderAccount(7);

        // if ($user->branch_id == null) {
        //     $totdayPurchase = Purchases::whereDate('date', today())->sum('grand_total');
        // } else {
        //     $totdayPurchase = Purchases::whereDate('date', today())->where('branch_id', $user->branch_id)->sum('grand_total');
        // }

        $totdayPurchase = getUnderAccount(7, date('Y-m-d'));

        // if ($user->branch_id == null) {

        //     $sale = Sale::sum('sub_total');
        //     //  dd($sale);
        // } else {

        //     $sale = Sale::where('branch_id', $user->branch_id)->sum('sub_total');
        //     //   dd($sale);
        // }

        $sale = getUnderAccount(9, null, false);

        if ($user->branch_id == null) {
            $totalService = Service::sum('amount');
        } else {
            $totalService = Service::where('branch_id', $user->branch_id)->sum('amount');
        }

        // if ($user->branch_id == null) {
        //     $todaySale = Sale::whereDate('date', today())->sum('grand_total');
        // } else {
        //     $todaySale = Sale::whereDate('date', today())->where('branch_id', $user->branch_id)->sum('grand_total');
        // }

        $todaySale = getUnderAccount(9, date('Y-m-d'), false);

        // if ($user->branch_id == null) {
        //     $expense = Expense::sum('amount');
        // } else {
        //     $expense = Expense::where('branch_id', $user->branch_id)->sum('amount');
        // }

        $expense = getUnderAccount(6);
        $todayExpense = getUnderAccount(6, date('Y-m-d'));


        // if ($user->branch_id == null) {
        //     $todayExpense = Expense::whereDate('date', today())->sum('amount');
        // } else {
        //     $todayExpense = Expense::whereDate('date', today())->where('branch_id', $user->branch_id)->sum('amount');
        // }


        if ($user->branch_id == null) {
            $suppplierPayment = supplierLedger::where('payment_type', 'Collect')->sum('credit');
        } else {
            $suppplierPayment = supplierLedger::where('payment_type', 'Collect')->where('branch_id', $user->branch_id)->sum('credit');
        }

        //account balance
        // $getAcName = ChartOfAccount::where('parent_id', '=', '4')->get();
        // dd($getAcName);
        $totalcashbalance =  getUnderAccount(16);
        $totalbankbalance =  getUnderAccount(17);

        $totalemployee = Employee::count();
        $todayattendance = Attendance::whereDate("date", date("Y-m-d"))->count();

        //customer due
        // if ($user->branch_id == null) {
        //     $debitAB = customerLedger::sum('debit');
        //     $creditAB = customerLedger::sum('credit');
        //     // $customerDue = abs($creditAB - $debitAB);
        //     $customerDue =  number_format($creditAB - $debitAB, 2);
        // } else {
        //     $debitAB = customerLedger::where('branch_id', $user->branch_id)->sum('debit');
        //     $creditAB = customerLedger::where('branch_id', $user->branch_id)->sum('credit');
        //     $customerDue =  number_format($creditAB - $debitAB, 2);
        // }

        $customerDue = customerDue();

        //supplier due
        // if ($user->branch_id == null) {
        //     $debitAB = supplierLedger::sum('debit');
        //     $creditAB = supplierLedger::sum('credit');
        //     $supplierDue = $debitAB - $creditAB;
        // } else {
        //     $debitAB = supplierLedger::where('branch_id', $user->branch_id)->sum('debit');
        //     $creditAB = supplierLedger::where('branch_id', $user->branch_id)->sum('credit');
        //     $supplierDue = $debitAB - $creditAB;
        // }
        $supplierDue = supplierDue();


        // $customerPayment = customerLedger::where('payment_type', 'Collect')->sum('debit');
        $customerPayment = customerLedger::sum('debit');
        // dd($customerPayment);
        $userrole = UserRole::where('status', 'Active')->count();
        $customer = Customer::where('status', 'Active')->count();
        $Supplier = Supplier::where('status', 'Active')->count();
        $prjectDetails = Project::where('manager_id', $user->id)->first();

        //pie
        // $purchase = Purchases::sum('grand_total');
        // $sale = Sale::sum('grand_total');
        // $expense = Expense::sum('amount');

        //pending branch
        $pvConditon = array(
            'status' => 'Pending',
            'purchase_type' => 'Manual',
        );
        if ($user->branch_id == null) {
            $prPending = PurchaseRequisition::where('status', 'Pending')->count();
        } else {
            $prPending = PurchaseRequisition::where('status', 'Pending')->where('branch_id', $user->branch_id)->count();
        }
        if ($user->branch_id == null) {
            $poPending = PurchaseOrder::where('status', 'Pending')->count();
        } else {
            $poPending = PurchaseOrder::where('status', 'Pending')->where('branch_id', $user->branch_id)->count();
        }
        if ($user->branch_id == null) {
            $pvPending = Purchases::where($pvConditon)->count();
        } else {
            $pvPending = Purchases::where($pvConditon)->where('branch_id', $user->branch_id)->count();
        }
        if ($user->branch_id == null) {
            $trPending = Transfer::where('status', 'Pending')->count();
        } else {
            $trPending = Transfer::where('status', 'Pending')->where('from_branch_id', $user->branch_id)->count();
        }

        if ($user->branch_id == null) {
            $adjPending = StockAjdustment::where('status', 'Pending')->count();
        } else {
            $adjPending = StockAjdustment::where('status', 'Pending')->where('branch_id', $user->branch_id)->count();
        }

        if ($user->type == "Project") {

            $totalprojectexpence = ProjectExpense::where('project_id', $prjectDetails->id)->sum('amount');
            $todayprojectexpence = ProjectExpense::where('project_id', $prjectDetails->id)->where('date', today())->sum('amount');

            $productreq = ProjectRequisition::where('project_id', $prjectDetails->id)->sum('approve_qty');
            $productreqtoday = ProjectRequisition::where('project_id', $prjectDetails->id)->where('date', today())->sum('approve_qty');

            $useproduct = ProductUse::where('project_id', $prjectDetails->id)->sum('use_total');
            $usetotaltoday = ProductUse::where('project_id', $prjectDetails->id)->where('date', today())->sum('use_total');

            $returntotal = ProjectReturn::where('project_id', $prjectDetails->id)->sum('return_total');
            $returntoday = ProjectReturn::where('project_id', $prjectDetails->id)->where('date', today())->sum('return_total');
        }



        // Count records created today and approved
        $leave_aplication = LeaveApplication::whereDate('created_at', today())
            ->where('status', 'approved')
            ->count();

        $activeEmployeeCount = Employee::where('status', 'Active')->count();
        $total_absent = $activeEmployeeCount - $leave_aplication;

        $approved_leave = LeaveApplication::where('status', 'approved')->count();

        $startDate = Carbon::now()->subMonth(); // One month ago
        $endDate = Carbon::now();
        $monthly_created_employee = \App\Models\Employee::where('status', 'Active')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->count();

        $monthly_lone_approved = Lone::where('status', 'approved')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->count();

        $monthly_lone = Lone::whereBetween('created_at', [$startDate, $endDate])->count();

        // dd(date('m-d-Y'));
        //pending project
        if ($user->branch_id == null) {
            $PendingReturn = ProjectReturn::where('status', 'Pending')->count();
        } else {
            $PendingReturn = ProjectReturn::where('status', 'Pending')->where('branch_id', $user->branch_id)->count();
        }
        if ($user->branch_id == null) {
            $PendingReq = ProjectRequisition::where('status', 'Pending')->count();
        } else {
            $PendingReq = ProjectRequisition::where('status', 'Pending')->where('branch_id', $user->branch_id)->count();
        }

        $rollper = auth()->user()->userRole->dashboard_id;
        $rollper = explode(',', $rollper);

        return view('backend.pages.dashboard.index', get_defined_vars());
    }
}
