

<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"> Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('settings.commissionRules.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('settings.commissionRules.index')); ?>">Commission Rules List</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Add New Commission Rules</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Add New Commission Rules</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('settings.commissionRules.index')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('settings.commissionRules.index')); ?>"><i
                                    class="fa fa-list"></i> Commission Rules List</a>
                        <?php endif; ?>
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="<?php echo e(route('settings.commissionRules.store')); ?>" novalidate>
                        <?php echo csrf_field(); ?>
                
                        <!-- Salesperson Dropdown -->
                        <label for="employee_id">Salesperson:</label>
                        <select name="employee_id" id="employee_id" class="form-control select2" required>
                            <option value="">-- Select Salesperson --</option>
                            <?php $__currentLoopData = $salespersons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salesperson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($salesperson->id); ?>"><?php echo e($salesperson->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['employee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                
                        <!-- Commission Type Dropdown -->
                        <label for="commission_type">Type:</label>
                        <select name="commission_type" id="commission_type" class="form-control" required>
                            <option value="fixed">Fixed</option>
                            <option value="tiered">Tiered</option>
                            <option value="product_based">Product Based</option>
                        </select>
                        <?php $__errorArgs = ['commission_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                
                        <!-- Fixed Percentage (Only for Fixed Type) -->
                        <div id="fixed_percentage_wrapper">
                            <label for="fixed_percentage">Fixed Percentage:</label>
                            <input type="number" step="0.01" name="fixed_percentage" id="fixed_percentage" class="form-control">
                            <?php $__errorArgs = ['fixed_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                
                        <!-- Min & Max Amount (Only for Tiered Type) -->
                        <div id="tiered_wrapper" style="display: none;">
                            <label for="min_amount">Min Amount:</label>
                            <input type="number" step="0.01" name="min_amount" id="min_amount" class="form-control">
                            <?php $__errorArgs = ['min_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                
                            <label for="max_amount">Max Amount:</label>
                            <input type="number" step="0.01" name="max_amount" id="max_amount" class="form-control">
                            <?php $__errorArgs = ['max_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                
                        <!-- Percentage (For Tiered & Product-Based Types) -->
                        <div id="percentage_wrapper" style="display: none;">
                            <label for="percentage">Percentage:</label>
                            <input type="number" step="0.01" name="percentage" id="percentage" class="form-control">
                            <?php $__errorArgs = ['percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                
                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary mt-3">Save</button>
                    </form>
                </div>
                <!-- /.card-body -->
              
            </div>
        </div>
        <!-- /.col-->
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const commissionType = document.getElementById('commission_type');
            const fixedPercentageWrapper = document.getElementById('fixed_percentage_wrapper');
            const tieredWrapper = document.getElementById('tiered_wrapper');
            const percentageWrapper = document.getElementById('percentage_wrapper');
    
            function toggleFields() {
                const selectedType = commissionType.value;
                
                if (selectedType === 'fixed') {
                    fixedPercentageWrapper.style.display = 'block';
                    tieredWrapper.style.display = 'none';
                    percentageWrapper.style.display = 'none';
                } 
                else if (selectedType === 'tiered') {
                    fixedPercentageWrapper.style.display = 'none';
                    tieredWrapper.style.display = 'block';
                    percentageWrapper.style.display = 'block';
                } 
                else if (selectedType === 'product_based') {
                    fixedPercentageWrapper.style.display = 'none';
                    tieredWrapper.style.display = 'none';
                    percentageWrapper.style.display = 'block';
                }
            }
    
            commissionType.addEventListener('change', toggleFields);
            toggleFields(); // Call on load to handle default selection
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/settings/commission_rules/create.blade.php ENDPATH**/ ?>