<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"> Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('settings.openingbalance.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('settings.openingbalance.index')); ?>">Opening
                                    Balance List</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Add New Opening</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Add New Opening Balance</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('settings.openingbalance.index')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('settings.openingbalance.index')); ?>"><i
                                    class="fa fa-list"></i>
                                Opening List
                            </a>
                        <?php endif; ?>
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="<?php echo e(route('settings.openingbalance.store')); ?>"
                        novalidate>
                        <?php echo csrf_field(); ?>
                        <table class="table table-bordered" id="datatable">
                            <thead>
                                <tr>
                                    <th>Account Name</th>
                                    <th>Debit</th>
                                    <th>Credit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.opening-account-balance','data' => ['accounts' => $accounts]]); ?>
<?php $component->withName('opening-account-balance'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['accounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($accounts)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Total</th>
                                    <th class="totalDebit"></th>
                                    <th class="totalCredit"></th>
                                </tr>
                            </tfoot>
                        </table>
                        <button type="submit" class="btn btn-primary">Save Changes</button>

                    </form>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>

    <script>
        let debit = 0;
        let credit = 0;

        // Loop through all elements with class "debit"
        $(".debit").each(function() {
            const value = parseFloat($(this).val()) || 0; // Convert to a number or default to 0
            debit += value;
        });


        $("#datatable").DataTable();
        // Loop through all elements with class "credit"
        $(".credit").each(function() {
            const value = parseFloat($(this).val()) || 0; // Convert to a number or default to 0
            credit += value;
        });

        // Set the total values in the appropriate elements
        $('.totalDebit').text(debit.toFixed(2)); // Format to 2 decimal places
        $('.totalCredit').text(credit.toFixed(2)); // Format to 2 decimal places



        function getAccountList(branchId) {
            $.ajax({
                url: "/admin/getAllAccountHead/", // path to function
                method: "GET",
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    branchId: branchId
                },
                success: function(data) {
                    $("#accountId").show()
                    let html = `

                        <div class="form-group">
                            <label>Accounts</label>
                            <select name="to_account_id" class="form-control accountsList select2 accountList" >
                                ${data}
                            </select>
                        </div>
                `;
                    $('.accountList').html(html);
                    $('.accountsList').select2();
                },
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
            $("#datatable").DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\laragon\www\jubayer\resources\views/backend/pages/settings/opening/create.blade.php ENDPATH**/ ?>