

<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<style>
        .table-container {
            margin: 20px 0;
        }
        .form-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .calculation-panel {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
        }
        .readonly-input {
            background-color: #f8f9fa;
        }
        .text-right {
            text-align: right;
        }
        
        /* Image preview styles */
        .image-preview-container {
            position: relative;
            display: inline-block;
            margin: 10px 0;
        }
        .image-preview {
            max-width: 200px;
            max-height: 200px;
            border: 2px dashed #ddd;
            border-radius: 8px;
            padding: 10px;
            display: none;
        }
        .image-preview img {
            max-width: 100%;
            max-height: 100%;
            border-radius: 4px;
        }
        .image-remove-btn {
            position: absolute;
            top: 5px;
            right: 5px;
            background: #dc3545;
            color: white;
            border: none;
            border-radius: 50%;
            width: 25px;
            height: 25px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
        }
        .image-remove-btn:hover {
            background: #c82333;
        }
        .file-input-wrapper {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
        }
        .file-input-wrapper input[type=file] {
            position: absolute;
            left: -9999px;
        }
        .file-input-label {
            display: block;
            padding: 10px 15px;
            cursor: pointer;
            background: #f8f9fa;
            border: 2px dashed #ddd;
            border-radius: 8px;
            text-align: center;
            transition: all 0.3s ease;
        }
        .file-input-label:hover {
            background: #e9ecef;
            border-color: #007bff;
        }
        .file-input-label i {
            font-size: 24px;
            color: #6c757d;
            margin-bottom: 5px;
        }
        .file-name {
            margin-top: 5px;
            font-size: 12px;
            color: #6c757d;
        }
</style>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"> Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('inventorySetup.supplier.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('inventorySetup.supplier.index')); ?>">Supplier
                                    List</a>
                            </li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Add New Supplier</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Add New Supplier</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('settings.supplier.index')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('inventorySetup.supplier.index')); ?>"><i
                                    class="fa fa-list"></i>
                                Supplier List</a>
                        <?php endif; ?>
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="<?php echo e(route('inventorySetup.supplier.store')); ?>"
                        novalidate enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="col-md-12 mb-3">
                                <span class="bg-green" style="padding: 5px; font-weight : bold"
                                    for="validationCustom01">Supplier Code * : <?php echo e($supplierCode); ?></span>
                                <input type="hidden" name="supplierCode" class="form-control" id=""
                                    value="<?php echo e($supplierCode); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Supplier Name * :</label>
                                <input type="text" name="name" class="form-control" id="validationCustom01"
                                    placeholder="Supplier Name" value="<?php echo e(old('name')); ?>">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                               <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Branch Name * :

                                  
                                </label>
                                <select class="form-control select2" name="branch_id">
                                    <option selected disabled value="">--Select--</option>
                                   <?php if(auth()->user()->role_id > 1): ?>
                                    <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>" <?php echo e(auth()->user()->branch_id == $value->id ? 'selected' :''); ?>><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?> 

                                   <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02"> E-mail :</label>
                                <input type="text" name="email" class="form-control" id="validationCustom02"
                                    placeholder="E-mail" value="<?php echo e(old('email')); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                             <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Phone * :</label>
                                <input type="text" name="phone" class="form-control" id="validationCustom01"
                                    placeholder="Phone" value="<?php echo e(old('phone')); ?>" required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6 mb-3">

                            <div class="form-group">
                                <label>Image</label>
                                <div class="file-input-wrapper">
                                    <input type="file" 
                                           id="image-input" 
                                           name="image" 
                                           accept="image/*,.pdf,.doc,.docx"
                                           class="<?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <label for="image-input" class="file-input-label">
                                        <i class="fa fa-cloud-upload"></i>
                                        <div>Click to select file</div>
                                        <small>Images, PDF, DOC files supported</small>
                                    </label>
                                    <div class="file-name" id="file-name"></div>
                                </div>
                                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                
                                <!-- Image Preview Container -->
                                <div class="image-preview-container">
                                    <div class="image-preview" id="image-preview">
                                        <img id="preview-img" src="" alt="Preview">
                                        <button type="button" class="image-remove-btn" id="remove-image">
                                            <i class="fa fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">BIN :</label>
                                <input type="text" name="specialNumber" class="form-control" id="validationCustom01"
                                    placeholder="BIN Number" value="<?php echo e(old('specialNumber')); ?>" required>
                                <?php $__errorArgs = ['specialNumber'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02">Address :</label>
                                <input name="address" class="form-control" id="validationCustom02" placeholder="Address"
                                    value="<?php echo e(old('address')); ?>" required>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <button class="btn btn-info" type="submit"><i class="fa fa-save"></i> &nbsp;Save</button>
                    </form>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
      <script>
          $(document).ready(function(){
         function showBranchDiv(type) {
        if (type != "Project") {
            $("#showBranch").show(500);
        } else {
            $("#showBranch").hide(500);
        }
    }

       $('#image-input').on('change', function(e) {
            const file = e.target.files[0];
            const fileName = $('#file-name');
            const imagePreview = $('#image-preview');
            const previewImg = $('#preview-img');
            
            if (file) {
                // Show file name
                fileName.text(file.name);
                
                // Check if file is an image
                if (file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        previewImg.attr('src', e.target.result);
                        imagePreview.show();
                    }
                    reader.readAsDataURL(file);
                } else {
                    // For non-image files, show file info
                    imagePreview.hide();
                    fileName.html(`<i class="fa fa-file"></i> ${file.name} (${(file.size / 1024).toFixed(2)} KB)`);
                }
                
                // Update label text
                $('.file-input-label').html(`
                    <i class="fa fa-check-circle" style="color: #28a745;"></i>
                    <div>File selected successfully</div>
                    <small>Click to change file</small>
                `);
            }
        });

        // Remove image functionality
        $('#remove-image').on('click', function() {
            $('#image-input').val('');
            $('#image-preview').hide();
            $('#file-name').text('');
            $('.file-input-label').html(`
                <i class="fa fa-cloud-upload"></i>
                <div>Click to select file</div>
                <small>Images, PDF, DOC files supported</small>
            `);
        });

        // Drag and drop functionality
        $('.file-input-label').on('dragover', function(e) {
            e.preventDefault();
            $(this).addClass('drag-over');
        });

        $('.file-input-label').on('dragleave', function(e) {
            e.preventDefault();
            $(this).removeClass('drag-over');
        });

        $('.file-input-label').on('drop', function(e) {
            e.preventDefault();
            $(this).removeClass('drag-over');
            
            const files = e.originalEvent.dataTransfer.files;
            if (files.length > 0) {
                $('#image-input')[0].files = files;
                $('#image-input').trigger('change');
            }
        });
    })
   

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/inventories/supplier/create.blade.php ENDPATH**/ ?>