

<?php $__env->startSection('title'); ?>
    Dashboard Page - Admin Panel
<?php $__env->stopSection(); ?>
<style>
    .small-box>.small-box-footer {
        border: none;
        width: 100%;
    }

    .fixed-height-table {
        max-height: 300px;
        /* Set your desired height */
        overflow-y: auto;
    }

    .fixed-height-table thead th {
        position: sticky;
        top: 0;
        background: #343a40;
        color: #fff;
        z-index: 1;
    }

    .fixed-height-table tfoot th {
        position: sticky;
        bottom: 0;
        background: #f8f9fa;
        z-index: 1;
    }
</style>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Stock Report</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
    <div style="display:flex; gap:10px">
           <?php $__currentLoopData = $currentStock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $totalQty = 0;
        $totalKg = 0;
    ?>

    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $accessoryId = $item->product_id;

            $total_in_kg = $stockinSums[$accessoryId] ?? 0;
            $total_in_qty = $stockinQty[$accessoryId] ?? 0;
            $rate_per_kg = $total_in_qty > 0 ? $total_in_kg / $total_in_qty : 0;

            $total_out_qty = $stockoutSums[$accessoryId] ?? 0;
            $total_out_kg = $total_out_qty * $rate_per_kg;

            $available_kg = $total_in_kg - $total_out_kg;

            $totalQty += $item->quantity;
            $totalKg += $item->kg;
        ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div style="font-size: 20px; font-weight: 900; border: 1px solid; padding-left: 10px; padding-right: 10px;">
        <?php if($unit === "ROOL"): ?>
          <span style="border-right

: 2px solid;
    padding-right: 2px;"><?php echo e($unit); ?> <?php echo e($totalQty); ?></span> <span>KG - <?php echo e($totalKg); ?></span>  
        <?php elseif($unit === "PS"): ?>
            <?php echo e($unit); ?> - <?php echo e($totalQty); ?>

        <?php endif; ?>
    </div>
    
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>
                    
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
   


 <div class="row">


    <?php
    $totalQty = 0;
    $totalKg =0;
?>

<?php $__currentLoopData = $currentStock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-md-12 mb-4">
        <h5 class="mb-2"><?php echo e($unit); ?> Items</h5>
        <div class=" ">
            <table class="table table-bordered table-striped mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>SL</th>
                        <th>Product</th>
                        <th>Unit</th>
                        <th>Quantity</th>
                        <th>Available (KG)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; $totalQty = 0; $totalKg = 0; ?>
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $accessoryId = $item->product_id;

                            $total_in_kg = $stockinSums[$accessoryId] ?? 0;
                            $total_in_qty = $stockinQty[$accessoryId] ?? 0;
                            $rate_per_kg = $total_in_qty > 0 ? $total_in_kg / $total_in_qty : 0;

                            $total_out_qty = $stockoutSums[$accessoryId] ?? 0;
                            $total_out_kg = $total_out_qty * $rate_per_kg;

                            $available_kg = $total_in_kg - $total_out_kg;
                            $accessory = $item->accessories;

                            $totalQty += $item->quantity;
                            $totalKg += $item->kg;
                        ?>
                        <tr>
                            <td><?php echo e($i++); ?></td>
                            <td><?php echo e($accessory->name ?? 'N/A'); ?></td>
                            <td><?php echo e($accessory->unit ?? 'N/A'); ?></td>
                            <td><?php echo e($item->quantity); ?></td>
                            <td><strong><?php echo e(number_format($item->kg, 2)); ?></strong></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3" class="text-end">Total</th>
                        <th><?php echo e($totalQty); ?></th>
                        <th><?php echo e(number_format($totalKg, 2)); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </div>
   



<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/dashboard/stock.blade.php ENDPATH**/ ?>