
<?php $__env->startSection('title'); ?>
    inventory - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
        .account-card {
            transition: transform 0.2s;
        }
        .account-card:hover {
            transform: translateY(-2px);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Total Balance</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active"><span>Account Information</span></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Account Information</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    
                    <div class="row">
                         <?php $__currentLoopData = $accountsInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $balanceDebit = \App\Models\AccountTransaction::where('account_id', $account->id)->sum(
                                    'debit',
                                );
                            ?>

                            <div class="col-md-4 mb-3">
                                <div class="card shadow-sm border-left-primary"
                                    style="color:#fff;background: rgb(58, 56, 56)">
                                    <div class="card-body" style="  display: flex; gap: 10px;">
                                        <h5 class="card-title"><?php echo e($account->account_name); ?>-</h5>
                                        <p class="card-text">
                                            <?php echo e(number_format($balanceDebit, 2)); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    
                    <div class="table-responsive">
                        <form method="GET" class="mb-3">
                            <div class="row">
                                <div class="col-md-3">
                                    <select name="account_id" class="form-control form-control-sm select2">
                                        <option value="">-- Select Bank --</option>
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.account','data' => ['setAccounts' => $accounts]]); ?>
<?php $component->withName('account'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['setAccounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($accounts)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <input type="date" name="from_date" class="form-control"
                                        placeholder="From Date" value="<?php echo e($request->from_date); ?>">
                                </div>
                                <div class="col-md-3">
                                    <input type="date" name="to_date" class="form-control"
                                        placeholder="To Date" value="<?php echo e($request->to_date); ?>">
                                </div>
                                <div class="col-md-3">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> Search
                                    </button>
                                    <a href="<?php echo e(route('bank.info.dashboard')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> Reset
                                    </a>
                                </div>
                            </div>
                        </form>

                        
                        <table class="table table-bordered table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Invoice</th>
                                    <th>Date</th>
                                    <th>Customer Name</th>
                                    <th>Advance Payment</th>
                                    <th>Due Payment</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $serial = $transactionsPaginator->firstItem() ?? 1; ?>

                                <?php $__empty_1 = true; $__currentLoopData = $transactionsPaginator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $sales = App\Models\Sale::where('invoice_no', $invoice['invoice'])->first();
                                        $customer = null;

                                        if ($sales) {
                                            $ledger = App\Models\ChartOfAccount::find($sales->ledger_id);
                                            $customer = App\Models\Customer::where('id', $ledger->accountable_id)->first();
                                        }
                                        
                                        $uniqueBankNames = array_unique($invoice['bank_names']);
                                        $bankNamesDisplay = implode(', ', $uniqueBankNames);
                                    ?>

                                    <tr>
                                        <td><?php echo e($serial++); ?></td>
                                        <td>
                                            <span class="badge badge-info"><?php echo e($invoice['invoice']); ?></span>
                                        </td>
                                        <td><?php echo e($invoice['date']); ?></td>
                                        <td><?php echo e($customer->name ?? '-'); ?></td>

                                        
                                        <td>
                                         <?php if($invoice['advance_payment'] > 0): ?>
    <span class="text-success">
        <?php echo e($invoice['advance_bank'] ?? 'N/A'); ?> - <?php echo e(number_format($invoice['advance_payment'], 2)); ?>

    </span>
<?php else: ?>
    <span class="text-muted">-</span>
<?php endif; ?>

                                        </td>

                                        
                                        <td>
                                          <?php if($invoice['due_payment'] > 0): ?>
    <span class="text-warning">
        <?php echo e($invoice['due_bank'] ?? 'N/A'); ?> - <?php echo e(number_format($invoice['due_payment'], 2)); ?>

    </span>
<?php else: ?>
    <span class="text-muted">-</span>
<?php endif; ?>

                                        </td>
                                        <td> <?php if($sales): ?><a href="<?php echo e(route('sale.sale.show', $sales->id)); ?>"class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a><?php endif; ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">
                                            <div class="alert alert-info mb-0">
                                                <i class="fas fa-info-circle"></i> No transactions found.
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>

                        
                        <div class="d-flex justify-content-center">
                            <?php echo $transactionsPaginator->appends(request()->query())->links(); ?>

                        </div>
                    </div>
                </div>
                
                <div class="card-footer">
                    <small class="text-muted">
                        Showing <?php echo e($transactionsPaginator->count()); ?> of <?php echo e($transactionsPaginator->total()); ?> results
                    </small>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/dashboard/bank.blade.php ENDPATH**/ ?>