<?php $__env->startSection('title'); ?>
    Employee - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" />
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"> HRM </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('hrm.attendance.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('hrm.attendance.index')); ?>">Attendence
                                    List</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Add New Attendence</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<style>
    .btn-custom {
        padding: 10px 13px;
        border: none;
        border-radius: 5px 5px 0 0;
        background: green;
        color: white
    }
</style>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Attendence</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('hrm.attendance.index')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('hrm.attendance.create')); ?>"><i
                                    class="fa fa-plus"></i>
                                Add New</a>
                        <?php endif; ?>
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <button class="check_in btn-custom" type="button">
                        Check In
                    </button>
                    <button class="check_out btn-custom" type="button">
                        Check Out
                    </button>
                    <div class="collapse active show" id="check_in">
                        <div class="card-header">
                            <h4 class="card-title">Check In</h4>
                        </div>
                        <div class="card card-body">
                            <form class="needs-validation" method="POST" action="<?php echo e(route('hrm.attendance.sign_in')); ?>"
                                novalidate>
                                <?php echo csrf_field(); ?>
                                <div class="form-group row">
                                    <label for="intime" class="col-sm-3 col-form-label">Employee Name*</label>
                                    <div class="col-md-4 mb-1">
                                        <?php if(auth()->user()->employee): ?>
                                            <input type="hidden" readonly name="emplyee_id"
                                                value="<?php echo e(auth()->user()->employee->id ?? 0); ?>">
                                        <?php elseif(auth()->user()->type == 'Admin'): ?>
                                            <select name="emplyee_id" class="form-control select2" id="">
                                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        <?php endif; ?>

                                        <?php echo e(auth()->user()->employee->name ?? ''); ?>


                                        <?php $__errorArgs = ['emplyee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="intime" class="col-sm-3 col-form-label">Date *</label>
                                    <div class="col-md-4 mb-1">
                                        <input type="date" id="current-date" class="form-control" name="date"
                                        <?php echo e(auth()->user()->type == 'Admin' ? "":"readonly"); ?>>

                                        <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error text-red text-bold"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label" for="Emplyee">Punch Time* <span
                                            class="text-danger">*</span></label>
                                    <div class="col-md-4 mb-1">
                                        <input type="time" id="current-time" class="form-control" name="sign_in"
                                        <?php echo e(auth()->user()->type == 'Admin' ? "":"readonly"); ?>>
                                        <?php $__errorArgs = ['sign_in'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error text-red text-bold"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Location</label>
                                    <div class="col-md-4 mb-1">
                                        <div id="map-checkin" style="height: 200px; width: 100%;"></div>
                                        <input type="hidden" id="latitude" name="latitude">
                                        <input type="hidden" id="longitude" name="longitude">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <button class="btn btn-info" type="submit"><i class="fa fa-save"></i>
                                        &nbsp;Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="collapse" id="check_out">
                        <div class="card-header">
                            <h4 class="card-title">Check Out</h4>
                        </div>
                        <div class="card card-body">
                            <form class="needs-validation" method="POST" action="<?php echo e(route('hrm.attendance.sign_out')); ?>"
                                novalidate>
                                <?php echo csrf_field(); ?>
                                <div class="form-group row">
                                    <label for="intime" class="col-sm-3 col-form-label">Employee Name*</label>
                                    <div class="col-md-4 mb-1">
                                        <?php if(auth()->user()->employee): ?>
                                            <input type="hidden" readonly name="emplyee_id"
                                                value="<?php echo e(auth()->user()->employee->id ?? 0); ?>">
                                        <?php elseif(auth()->user()->type == 'Admin'): ?>
                                            <select name="emplyee_id" class="form-control select2" id="">
                                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        <?php endif; ?>

                                        <?php echo e(auth()->user()->employee->name ?? ''); ?>

                                        <?php $__errorArgs = ['emplyee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="intime" class="col-sm-3 col-form-label">Date *</label>
                                    <div class="col-md-4 mb-1">
                                        <input type="date" id="current-date2" class="form-control" name="date"
                                             <?php echo e(auth()->user()->type == 'Admin' ? "":"readonly"); ?>>
                                        <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error text-red text-bold"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label" for="Emplyee">Punch Time* <span
                                            class="text-danger">*</span></label>
                                    <div class="col-md-4 mb-1">
                                        <input type="time" id="current-time2" class="form-control" name="sign_out"
                                        <?php echo e(auth()->user()->type == 'Admin' ? "":"readonly"); ?>>
                                        <?php $__errorArgs = ['sign_out'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error text-red text-bold"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Location</label>
                                    <div class="col-md-4 mb-1">
                                        <div id="map-checkout" style="height: 200px; width: 100%;"></div>
                                        <input type="hidden" id="latitude2" name="latitude">
                                        <input type="hidden" id="longitude2" name="longitude">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <button class="btn btn-info" type="submit"><i class="fa fa-save"></i>
                                        &nbsp;Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js"></script>
    <script>
        $(document).ready(function() {
            if ("<?php echo e(session()->get('sign')); ?>" == "0") {
                $('#check_in').addClass('active show');
                $('#check_out').removeClass('active show');
                $('.check_out').css('background', '#8fbc8f');
                $('.check_in').css('background', 'green');
            } else if ("<?php echo e(session()->get('sign')); ?>" == "1") {
                $('#check_out').addClass('active show');
                $('#check_in').removeClass('active show');
                $('.check_in').css('background', '#8fbc8f');
                $('.check_out').css('background', 'green');
            } else {
                $('.check_out').css('background', '#8fbc8f');
                $('.check_in').css('background', 'green');
            }

            $('.check_in').on('click', function() {
                $('#check_in').addClass('active show');
                $('#check_out').removeClass('active show');
                $('.check_out').css('background', '#8fbc8f');
                $('.check_in').css('background', 'green');

            })
            $('.check_out').on('click', function() {
                $('#check_out').addClass('active show');
                $('#check_in').removeClass('active show');
                $('.check_in').css('background', '#8fbc8f');
                $('.check_out').css('background', 'green');

            })
        })
    </script>

    <script>
        function initMap(id, lat, lng) {
            // Initialize the map and set its view to the user's location
            var map = L.map(id).setView([lat, lng], 18);

            // Load and display the tile layer from OpenStreetMap
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(map);

            // Add a marker at the user's location
            L.marker([lat, lng]).addTo(map)
                .bindPopup('You are here!')
                .openPopup();
        }

        // Function to get the user's location
        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    var lat = position.coords.latitude;
                    var lng = position.coords.longitude;

                    // Set the hidden input values for both maps
                    document.getElementById('latitude').value = lat;
                    document.getElementById('longitude').value = lng;
                    document.getElementById('latitude2').value = lat;
                    document.getElementById('longitude2').value = lng;

                    // Initialize both maps with the user's location
                    initMap('map-checkin', lat, lng); // Map for Check In
                    initMap('map-checkout', lat, lng); // Map for Check Out
                }, function() {
                    alert('Geolocation failed or permission denied.');
                });
            } else {
                alert('Geolocation is not supported by this browser.');
            }
        }

        window.onload = function() {
            // Get current date and time
            var currentDate = new Date().toISOString().slice(0, 10);
            var currentTime = new Date().toLocaleTimeString('en-GB', {
                hour: '2-digit',
                minute: '2-digit'
            });

            // Set date and time values
            document.getElementById('current-date2').value = currentDate;
            document.getElementById('current-date').value = currentDate;
            document.getElementById('current-time').value = currentTime;
            document.getElementById('current-time2').value = currentTime;

            // Get user's location and display maps
            getLocation();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\XAMPP\htdocs\jubayer\resources\views/backend/pages/hrm/attendance/create.blade.php ENDPATH**/ ?>