<?php $__env->startSection('title'); ?>
    <?php
        $accountable = optional(optional($invoice->customer)->accountable);
        $name = $accountable->name ?? '';
        $phone = $accountable->phone ?? '';
        $invoiceNo = str_replace('SV', 'CN', $invoice->invoice_no ?? 'N/A');
    ?>

    <?php echo e($name); ?>_<?php echo e($invoiceNo); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .buyer-name {
            font-size: 36px;
            font-weight: 900;
            line-height: 1.2;
            word-break: break-word;
            margin-top: 5px;
        }

        .invoice-container {
            position: relative;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border: 1px solid #ddd;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            position: relative;
        }

        /* Watermark */
        .watermark {
            position: absolute;
            top: 10%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 100px;
            font-weight: bold;
            color: rgba(0, 0, 0, 0.05);
            z-index: -1;
            pointer-events: none;
        }

        /* Header Styling */
        .header {
            display: flex;
            align-items: center;
            background-color: #ffffff;
            /* White background */
            border-bottom: 2px solid #000000;
            /* Black underline */
            padding: 10px;
        }

        .header-left {
            width: 100%;
            /* Left part takes 20% of the header width */
        }

        .header-left .logo {
            max-width: 100%;
            /* Ensure the image fits within the left part */
            height: auto;
        }

        .header-right {
            width: 50%;
            /* Right part takes 80% of the header width */
            text-align: left;
        }

        .header-right h1 {
            font-size: 32px;
            font-weight: 600;
            color: #000000;
            text-align: right;
            margin: 0;
        }

        .header-right p {
            font-size: 16px;
            font-weight: 600;
            text-align: right;
            /* color: #420297; */
            margin: 5px 0 0;
        }

        /* Invoice Details Section */
        .invoice-details {
            margin-bottom: 20px;
        }

        .invoice-info {
            text-align: left;
            /* Align text to the left */
        }

        /* Button Styling */
        .invoice-button {
            display: block;
            /* Make the button a block element */
            width: 100%;
            /* Full width of the container */
            padding: 5px;
            /* Add padding for better appearance */
            background-color: #007BFF;
            /* Blue background color */
            color: #ffffff;
            /* White text color */
            font-size: 16px;
            /* Font size */
            font-weight: bold;
            /* Bold text */
            text-align: center;
            /* Center the text inside the button */
            border: none;
            /* Remove default border */
            border-radius: 5px;

            /* Pointer cursor on hover */
            margin-bottom: 15px;
            /* Add space below the button */
        }


        .invoice-details,
        .supplier-customer,
        .product-table,
        .totals,
        .attachments,
        .footer {
            margin-bottom: 20px;
        }

        .supplier-customer {
            display: flex;
            justify-content: space-between;
        }

        .supplier,
        .customer {
            width: 48%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table th,
        table td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: left;
        }

        table th {
            background-color: #f4f4f4;
        }

        .totals p,
        .attachments ul {
            margin-bottom: 10px;
        }

        .attachments ul {
            list-style-type: disc;
            padding-left: 20px;
        }

        .footer {
            display: flex;
            justify-content: space-between;
        }



        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }

        .contact-info a:hover {
            text-decoration: underline;
        }

        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            opacity: 0.1;
            z-index: 1;
            width: 729px;
            height: auto;
            user-select: none;
            pointer-events: none;
        }

        .watermark img {
            width: 100%;
            height: auto;
        }

        .custom-footer {
            background: #f2f2f2;
            padding: 20px 0;
            text-align: center;
            border-top: 3px solid #007bff;
            /* Blue border for a professional look */
        }

        .footer-container {
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .footer-section {
            flex: 1;
            min-width: 250px;
            padding: 10px;
            text-align: left;
        }

        .footer-section h5 {
            color: #333;
            font-size: 16px;
            margin-bottom: 10px;
            font-weight: bold;
        }

        .footer-section p {
            font-size: 14px;
            color: #0c0c0c;
            margin: 5px 0;
        }

        .footer-section a {
            color: #007bff;
            text-decoration: none;
            font-weight: bold;
        }

        .footer-section a:hover {
            text-decoration: underline;
        }

        .prepared-received-section {
            display: flex;
            justify-content: space-between;
            padding: 20px;
            border-top: 2px solid #ddd;
            margin-top: 20px;
        }

        .prepared-by,
        .received-by {
            flex: 1;
            padding: 10px;
        }

        .prepared-by h3,
        .received-by h3 {
            font-size: 18px;
            color: #333;
            margin-bottom: 10px;
            /* text-decoration: underline; */
        }

        .custom-table {
            width: 100%;
            border-collapse: collapse;
        }

        .custom-table td {
            padding: 5px;
            font-size: 14px;
            color: #080808;
        }

        .custom-table td:first-child {
            font-weight: bold;
            width: 100px;
        }

        .signature-line {
            margin-top: 40px;
            font-size: 18px;
            font-weight: bold;
            text-align: left;
        }

        body {
            font-size: 20px;
            /* Adjust as needed */
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-size: 26px;
            /* Larger headers */
        }

        table {
            font-size: 18px;
            border-collapse: collapse;
            border: 2px solid black;
            /* Outer border */
        }

        p,
        td,
        th {
            font-size: 18px;

        }

        .btn {
            font-size: 20px;
        }


        .invoice-container {
            font-size: 23px;
            /* Increase font size for better readability */
        }

        h1,
        h2,
        h3 {
            font-size: 30px;
            /* Adjust header sizes */
        }

        table td,
        table th {
            border: 1px solid black;
            /* Inner cell borders */
            font-size: 18px;
            /* Increase table text size */
        }

        p {
            font-size: 20px !important;
        }

        @media  print {
            .top-text {
                font-size: 24px
            }

            .buyer-name {
                font-size: 36px;
                font-weight: 900;
                line-height: 1.2;
                word-break: break-word;
                margin-top: 5px;
            }
        }

        .print-only {
            display: none;
        }

        .invoice-only {
            display: table-row;
        }

        /* On print: reverse visibility */
        @media  print {
            .print-only {
                display: table-row !important;
            }

            .invoice-only {
                display: none !important;
            }
        }

        @media  print {
            .print-footer-only-last {
                page-break-inside: avoid;
                break-inside: avoid;
                margin-top: 20px;
            }

            tfoot {
                display: none !important;
            }

            thead {
                display: table-header-group;
            }

            .no-print {
                display: none !important;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Sale </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('sale.sale.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('sale.sale.index')); ?>">Sale</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Sale List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">

            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Sales Invoice</h3>

                </div>
                <div class="card-body">
                    <div class="row no-print">
                        <div class="col-12">
                            <a onclick="printInvoice()" class="btn btn-default float-right my-2">
                                <i class="fas fa-print"></i> Print
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="invoice-container">
                <!-- Watermark -->

                <header class="header">
                    <div class="header-left text-center">
                        <!-- Replace 'logo.png' with the actual path to your logo image -->

                        <?php if(isset($companyInfo->invoice_logo)): ?>
                            <a href="<?php echo e(route('home')); ?>">
                                <img width="300px" class="text-center"
                                    src="<?php echo e(asset('/backend/invoicelogo/' . $companyInfo->invoice_logo)); ?>" style=""
                                    alt="">
                            </a>
                        <?php endif; ?>
                        <p style="padding-top: 20px"><b style="font-size: 20px !important;">
                                <i class="fas fa-map-marker-alt"></i> <?php echo e($companyInfo->address); ?>

                            </b></p>
                        <p style="margin-top: -15px">
                            <b style="font-size: 20px !important;">
                                <i class="fas fa-phone-volume"></i> <?php echo e($companyInfo->phone); ?>

                            </b> ||
                            <b style="font-size: 20px !important;">
                                <i class="fas fa-envelope"></i> <?php echo e($companyInfo->email); ?>

                            </b>
                        </p>
                         <p style="margin-top: -15px; margin-left: -44px;">
                    <b style="font-size: 20px !important;">
                        <i class="fab fa-facebook"></i> Jubairbangladesh
                    </b>
                    ||
                    <b style="font-size: 20px !important;">
                        <i class="fas fa-globe"></i> Jubairbangladesh.com
                    </b>
                </p>





                    </div>
                    
                </header>
                <div class="watermark">
                    <?php if(isset($companyInfo->invoice_logo)): ?>
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset('/backend/invoicelogo/' . $companyInfo->invoice_logo)); ?>" style=""
                                alt="">
                        </a>
                    <?php endif; ?>
                </div>
                <section class="invoice-details px-3" style="">
                    <div class="invoice-info" style="padding-top:15px">
                        <!-- Add the button here -->
                        <div class="row">
                            <div class="col-md-4 col-sm-4" style="font-size: 30px;">
                                <span class="top-text"> <b> Chalan No:
                                        <?php echo e(str_replace('SV', 'CN', $invoice->invoice_no ?? 'N/A')); ?> </b></span>
                            </div>

                            <div class="col-md-4 col-sm-4">
                                <div class="pt-2">
                                    <div class="invoice-button">
                                        <h3 style="font-weight: 600;">Invoice</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-4 text-right" style="font-size: 30px;">
                                <span class="top-text"> <b> Date :
                                        <?php echo e($invoice->date); ?> </b></span>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 text-left" style="padding-bottom:15px; margin-top: 15px;">
                                <h3
                                    style="    margin-bottom: -21px;
    font-weight: 600;
    font-size: 28px;
    border-bottom: 1px solid;
    width: 30%;
">
                                    BILL TO-:

                                </h3>

                                <br>
                                <b style="display:flex;padding-top:20px">
                                    <h3 style=" 
;  font-weight: 600;font-size:22px;width:115px"> Name:

                                    </h3>
                                    <span class="buyer-name"
                                        style="font-size: 36px; font-weight: 900;line-height: 1; margin-top: -8px;"><?php echo e(optional(optional($invoice->customer)->accountable)->name ?? ''); ?></span>
                                </b>
                            </div>
                            <div class="col-md-12" style="margin-bottom: 6px; margin-top: -18px;display:flex;">
                                <br>
                                <h3 style=" font-weight: 600;font-size:22px;padding-top: 15px;width:115px">Mobile No:
                                    
                                </h3>
                                <span style="font-size: 36px;font-weight: 900;margin-top: -4px;">
                                        <?php echo e(optional(optional($invoice->customer)->accountable)->phone ?? ''); ?> </span>
                                 <br>
                            </div>
                            <div class="col-md-12" style="margin-bottom: 6px; margin-top: -2px;display:flex;">

                                <h3 style=" font-weight: 600;line-height:1;font-size:22px;padding-top: 6px;width:115px">Address:

                                </h3>
                                <span style="font-size: 36px; font-weight: 900;line-height: 1;margin-top: -4px;">
                                    <?php echo e(optional(optional($invoice->customer)->accountable)->address ?? ''); ?> </span>
                            </div>
                        </div>

                    </div>
                </section>



                <section class="product-table px-3">
                    <table>
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Product Name </th>
                                <th>Fabric </th>
                                <th>Quantity </th>
                                <th>Unit Price (Tk)</th>
                                <th>Total Price (Tk)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $groupedDetails = $invoice->details->groupBy('team');
                                $sl = 0;
                                $gtotalQty = $invoice->details->sum('qty');
                                $gtotalUp = $invoice->details->sum('rate');
                                $gtotalPrice = $invoice->details->sum('price');
                            ?>

                            <?php $__currentLoopData = $groupedDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team => $groupedDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $totalQty = 0;
                                    $totalUp = 0;
                                    $totalPrice = 0;
                                    $gsubtotal = 0;
                                ?>
                                <?php if($team): ?>
                                    <tr>
                                        <td colspan="5"><b>Team: <?php echo e($team); ?></b></td>
                                    </tr>
                                <?php endif; ?>

                                <?php $__currentLoopData = $groupedDetail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $totalQty += $detail->qty;
                                        $totalUp += $detail->rate;
                                        $totalPrice += $detail->price;
                                        $subtotal = number_format($totalPrice, 2);
                                        $sl += 1;
                                    ?>
                                    <tr class="view print-only">
                                        <td style="text-align: center;width:145px"><?php echo e($sl); ?></td>
                                        <td style="width:180px"> <?php echo e(optional($detail->product)->getRawOriginal('name') ?? 'N/A'); ?>

                                        </td>
                                        <td style="width:200px">
                                              <?php echo e(optional($detail->fabricDetails)->getRawOriginal('name') ?? 'N/A'); ?></td>
                                        <td class="text-center" style="width:125px"><?php echo e($detail->qty ?? 'N/A'); ?>

                                            <?php echo e(optional(optional(optional($detail)->product)->unit)->name ?? 'N/A'); ?></td>
                                        <td class="text-right" style="width:180px">
                                            <?php echo e(number_format($detail->rate, 2) ?? '0'); ?></td>
                                        <td class="text-right"><?php echo e(number_format($detail->price, 2) ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr class="view invoice-only">
                                        <td style="width:138px"><?php echo e($sl); ?></td>
                                        <td style="width:180px"> <?php echo e(optional($detail->product)->getRawOriginal('name') ?? 'N/A'); ?>

                                        </td>
                                        <td style="width:190px">
                                              <?php echo e(optional($detail->fabricDetails)->getRawOriginal('name') ?? 'N/A'); ?></td>
                                        <td class="text-center" style="width:120px"><?php echo e($detail->qty ?? 'N/A'); ?>

                                            <?php echo e(optional(optional(optional($detail)->product)->unit)->name ?? 'N/A'); ?></td>
                                        <td class="text-right" style="width:180px">
                                            <?php echo e(number_format($detail->rate, 2) ?? '0'); ?></td>
                                        <td class="text-right"><?php echo e(number_format($detail->price, 2) ?? 'N/A'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <tr class="view print-only">
                                    <th colspan="1" style="text-align: center" style="text-align: center;width:145px">
                                        SUBTOTAL</th>
                                    <th style="width:180px"></th>
                                    <th style="width:200px"></th>
                                    <th class="text-right" style="width:125px"><?php echo e(number_format($totalQty, 2)); ?></th>
                                    <th class="text-right" style="width:180px"><?php echo e(number_format($totalUp, 2)); ?></th>
                                    <th class="text-right"><?php echo e($subtotal); ?></th>
                                </tr>
                                <tr class="view invoice-only">
                                    <th colspan="1" style="text-align: center;width:138px">SUBTOTAL</th>
                                    <th style="width:180px"></th>
                                    <th style="width:190px"></th>
                                    <th class="text-right" style="width:120px"><?php echo e(number_format($totalQty, 2)); ?></th>
                                    <th class="text-right" style="width:180px"><?php echo e(number_format($totalUp, 2)); ?></th>
                                    <th class="text-right"><?php echo e($subtotal); ?></th>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <div class="print-footer-only-last ">
                        <table>
                            <tbody>
                                <tr class="view print-only">
                                    <th colspan="1" style="text-align: center;width:145px">TOTAL</th>
                                    <th class="text-right" style="width:180px"></th>
                                    <th class="text-right" style="width:200px"></th>
                                    <th class="text-right" style="width:125px"><?php echo e(number_format($gtotalQty, 2)); ?></th>
                                    <th class="text-right" style="width:180px"><?php echo e(number_format($gtotalUp, 2)); ?></th>
                                    <th class="text-right"><?php echo e(number_format($gtotalPrice, 2)); ?></th>
                                </tr>
                                <tr class="view invoice-only">
                                    <th colspan="1" style="text-align: center;width:138px">TOTAL</th>
                                    <th class="text-right" style="width:180px"></th>
                                    <th class="text-right" style="width:190px"></th>
                                    <th class="text-right" style="width:120px"><?php echo e(number_format($gtotalQty, 2)); ?></th>
                                    <th class="text-right" style="width:180px"><?php echo e(number_format($gtotalUp, 2)); ?></th>
                                    <th class="text-right"><?php echo e(number_format($gtotalPrice, 2)); ?></th>
                                </tr>


                                <?php if($invoice->discount): ?>
                                    <tr>
                                        <td colspan="3"></td>
                                        <th></th>
                                        <th style="text-align:right;">Discount ( - ):</th>
                                        <td style="text-align:right">
                                            <b><?php echo e(number_format($invoice->discount, 2) ?? 0); ?></b></td>
                                    </tr>
                                <?php endif; ?>

                                <?php if($invoice->carrying_cost): ?>
                                    <tr>


                                        <th colspan="5" style="text-align:right;">Carrying Cost ( + ):</th>
                                        <td style="text-align:right">
                                            <b><?php echo e(number_format($invoice->carrying_cost, 2) ?? 0); ?></b></td>
                                    </tr>
                                <?php endif; ?>

                                <?php if($invoice->labor_bill): ?>
                                    <tr>

                                        <th style="text-align:right;" colspan="5">Labor Bill ( + ):</th>
                                        <td style="text-align:right">
                                            <b><?php echo e(number_format($invoice->labor_bill, 2) ?? 0); ?></b></td>
                                    </tr>
                                <?php endif; ?>

                               
                                    <tr>

                                        <th style="text-align:right;" colspan="5">Previous Due:</th>
                                        <td style="text-align:right">
                                            <b><?php echo e(number_format($invoice->previouse_due_amount , 2) ?? 0); ?></b></td>
                                    </tr>
                                     <tr>

                                        <th style="text-align:right;" colspan="5">Net Total:</th>
                                        <td style="text-align:right">
                                            <b><?php echo e(number_format((($invoice->previouse_due_amount + $gtotalPrice + $invoice->carrying_cost + $invoice->labor_bill) - $invoice->discount), 2) ?? 0); ?></b></td>
                                    </tr>
                              
<?php
    $advances = is_string($invoice->advance) ? json_decode($invoice->advance, true) : ($invoice->advance ?? []);
    $advanceLedgers = is_string($invoice->advance_ledger_id) ? json_decode($invoice->advance_ledger_id, true) : ($invoice->advance_ledger_id ?? []);
    $advanceAccounts = \App\Models\ChartOfAccount::whereIn('id', $advanceLedgers)->get()->keyBy('id');
?>

<?php if(!empty($advances)): ?>
    

   <?php
    $accountsWithAmounts = [];
    foreach ($advances as $index => $amount) {
        $ledgerId = $advanceLedgers[$index] ?? null;
        $account = $advanceAccounts[$ledgerId] ?? null;
        if ($account) {
            $shortName = ucfirst(strtolower(substr($account->account_name, 0, 3)));
            $accountsWithAmounts[] = $shortName . ': ' . number_format($amount ?? 0, 2);
        }
    }
?>

    <tr>
        <th style="text-align:right;" colspan="5">
             Advance (<?php echo e(implode(', ', $accountsWithAmounts)); ?>):
        </th>
        <td style="text-align:right">
            <b><?php echo e(number_format(array_sum($advances), 2)); ?></b>
        </td>
    </tr>
<?php endif; ?>







                                <tr>
                                    <?php
                                        $color = isset($invoice->account) ? 'black' : 'red';
                                        $accountName = isset($invoice->account)
                                            ? $invoice->account->account_name
                                            : 'Due';
                                    ?>

                                    <th colspan="5" style="text-align:right; color: <?php echo e($color); ?>;">Total
                                        Payable Amount (<?php echo e($accountName); ?>):</th>
                                    <td style="text-align:right; color: <?php echo e($color); ?>;">
                                        <b><?php echo e(number_format($invoice->net_total - $invoice->totalAdvance + $invoice->previouse_due_amount, 2) ?? 0); ?></b>
                                    </td>
                                </tr>

                                <tr>
                                    <td colspan="6"><b>In Words :</b>
                                        <?php echo e(ucfirst(Terbilang::make($invoice->net_total - $invoice->totalAdvance + $invoice->previouse_due_amount))); ?>

                                    </td>
                                </tr>

                                <tr>
                                    <td colspan="6"><b>Note :</b> <?php echo e($invoice->narration ?? 'N/A'); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </section>

                

                <div class="row table-borderless prepared-received-section">

                    <div class="col-md-4 prepared-by text-left">
                        <?php echo e($invoice->user->name ?? 'N/A'); ?>

                        <h3> <b> Prepared By: </b></h3>


                    </div>

                    <div class="col-md-4 received-by text-center">
                        <h3 style=" padding-top: 41px;"><b> Authorized Signature: </b></h3>
                        <!-- <p class="signature-line"></p> -->
                    </div>
                    <div class="col-md-4 received-by text-right">
                        <h3 style="  padding-top: 41px;"><b>Received By: </b></h3>
                        <!-- <p class="signature-line"></p> -->
                    </div>
                </div>
                

            </div>
            <!-- /.col-->
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        function printInvoice() {
            var printContents = document.querySelector('.invoice-container').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;

            location.reload(); // Reload to restore the original page
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/sale/invoice.blade.php ENDPATH**/ ?>