<?php if(isset($purchaseDetails) && $purchaseDetails->isNotEmpty()): ?>
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header no-print">
                <h3 class="card-title">Quick Purchase Report</h3>
                <a onclick="window.print()" class="btn btn-default float-right my-2 no-print">
                    <i class="fas fa-print"></i> Print
                </a>
                <div id="tableActions" class="float-right my-2 no-print"></div>
            </div>

            <div class="card-body">
                <div class="invoice p-3 mb-3">
                    <div class="row">
                        <div class="col-12 table-responsive">
                            <table class="table table-bordered">
                                <tr>
                                    <td class="text-center">
                                        <?php if(!empty($companyInfo->logo)): ?>
                                            <a href="<?php echo e(route('home')); ?>">
                                                <img width="200px" src="<?php echo e(asset('/backend/logo/' . $companyInfo->logo)); ?>" alt="Company Logo">
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td width="70%" class="text-center">
                                        <h3>Quick Purchase Report</h3>
                                        <h4>
                                            <b>From Date: <?php echo e(isset($fromDate) ? $fromDate->format('Y-m-d') : 'N/A'); ?></b>, 
                                            <b>To Date: <?php echo e(isset($toDate) ? $toDate->format('Y-m-d') : 'N/A'); ?></b>
                                        </h4>
                                    </td>
                                </tr>
                            </table>

                            <div class="table-responsive">
                                <table id="datatablexcel" class="display table-hover table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Product Name</th>
                                            <th>Price</th>
                                            <th>Quantity</th>
                                            <th>Total Price</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $totalSum = 0; ?>
                                        <?php $__currentLoopData = $purchaseDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $sale->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($key + 1); ?></td>
                                                    <td><?php echo e($product->product_name ?? 'N/A'); ?></td>
                                                    <td><?php echo e(number_format($product->price ?? 0, 2)); ?></td>
                                                    <td><?php echo e($product->quantity ?? 0); ?></td>
                                                    <td><?php echo e(number_format($product->total_price ?? 0, 2)); ?></td>
                                                </tr>
                                                <?php $totalSum += $product->total_price ?? 0; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="4" class="text-center">Total</th>
                                            <th><?php echo e(number_format($totalSum, 2)); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <br><br>
                            <p>Prepared By: _____________<br> Date: ________________</p>
                        </div>
                        <div class="col-md-4 text-center"></div>
                        <div class="col-md-4 text-right">
                            <br><br>
                            <p>Approved By: _______________<br> Date: _______________</p>
                        </div>

                        <div class="col-md-12 bg-success text-center mt-3 p-2 text-white">
                            Thank you for choosing <?php echo e($companyInfo->company_name ?? 'N/A'); ?> products.
                            We believe you will be satisfied with our services.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH I:\jubayer\resources\views/helpers2.blade.php ENDPATH**/ ?>