
<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
              .treeview {
            position: relative;
            font-family: Arial, sans-serif;
        }

        .treeview ul {
            list-style: none;
            padding-left: 20px;
        }

        .treeview li {
            margin: 5px 0;
            padding-left: 1em;
            position: relative;
        }

        .treeview li::before {
            content: "";
            position: absolute;
            left: -1em;
            top: 0;
            bottom: 0;
            border-left: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            width: 1em;
            height: 1em;
        }

        .treeview li:last-child::before {
            border-left: none;
        }

        .treeview span {
            display: inline-block;
            padding: 0.2em 0.5em;
            background: #fcffe9;
            border: 1px solid #ddd;
            border-radius: 0.25em;
        }

        .treeview .folder {
            font-weight: bold;
            cursor: pointer;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('settings.account.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('settings.account.index')); ?>">Account</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Chart of Accounts</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Chart of Accounts</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('settings.account.create')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('settings.account.create')); ?>"><i
                                    class="fas fa-plus"></i>
                                Add New</a>
                        <?php endif; ?>
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="treeview w-20 border">
                        <ul class="mb-1 pl-3 pb-2">
                            <?php $__currentLoopData = $rootAccount; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><i class="fas fa-folder-open folder-icone rotate"></i>
                                    <a class="text-dark" href="<?php echo e(route('settings.account.edit', $account->id)); ?>">
                                        <span><?php echo e($account->head_code ? $account->head_code . ' -' : ''); ?>

                                            <?php echo e($account->account_name); ?></span>
                                    </a>
                                    <?php if($account->subAccount->isNotEmpty()): ?>
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.account-sub','data' => ['subacounts' => $account->subAccount]]); ?>
<?php $component->withName('account-sub'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['subacounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($account->subAccount)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            $('.treeview').mdbTreeview();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/settings/account/index.blade.php ENDPATH**/ ?>