<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<style>
    /* Updated CSS for better image preview */
    .image-preview-container {
        position: relative;
        display: inline-block;
        margin: 10px 0;
    }

    .image-preview {
        max-width: 200px;
        max-height: 200px;
        border: 2px dashed #ddd;
        border-radius: 8px;
        padding: 10px;
        /* Show preview if image exists, hide if not */
        display: <?php echo e($editInfo->logo && file_exists(public_path('/backend/logo/' . $editInfo->logo)) ? 'block' : 'none'); ?>;
    }

    .image-preview img {
        max-width: 100%;
        max-height: 100%;
        border-radius: 4px;
        display: block;
    }

    .image-remove-btn {
        position: absolute;
        top: 5px;
        right: 5px;
        background: #dc3545;
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
    }

    .image-remove-btn:hover {
        background: #c82333;
    }

    .file-input-wrapper {
        position: relative;
        overflow: hidden;
        display: inline-block;
        width: 100%;
    }

    .file-input-wrapper input[type=file] {
        position: absolute;
        left: -9999px;
    }

    .file-input-label {
        display: block;
        padding: 10px 15px;
        cursor: pointer;
        background: #f8f9fa;
        border: 2px dashed #ddd;
        border-radius: 8px;
        text-align: center;
        transition: all 0.3s ease;
    }

    .file-input-label:hover {
        background: #e9ecef;
        border-color: #007bff;
    }

    .file-input-label i {
        font-size: 24px;
        color: #6c757d;
        margin-bottom: 5px;
    }

    .file-name {
        margin-top: 5px;
        font-size: 12px;
        color: #6c757d;
    }

    /* Additional styles for existing file display */
    .existing-file-info {
        background: #e8f5e8;
        border: 1px solid #d4edda;
        border-radius: 4px;
        padding: 10px;
        margin-top: 10px;
        font-size: 12px;
        color: #155724;
    }

    .existing-file-info i {
        color: #28a745;
        margin-right: 5px;
    }
</style>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('settings.customer.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('inventorySetup.customer.index')); ?>">Customer
                                    List</a>
                            </li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Edit Customer</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Customer Edit</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('inventorySetup.customer.create')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('inventorySetup.customer.create')); ?>"><i
                                    class="fas fa-plus"></i>
                                Add New</a>
                        <?php endif; ?>
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">

                    <form class="needs-validation" method="POST"
                        action="<?php echo e(route('inventorySetup.customer.update', $editInfo->id)); ?>" enctype="multipart/form-data"
                        novalidate>
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Contact Persion * :</label>
                                <input type="text" name="name" class="form-control" id="validationCustom01"
                                    placeholder="Contact Persion" value="<?php echo e($editInfo->name); ?>">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Company Name :</label>
                                <input type="text" name="co_name" class="form-control" id="validationCustom01"
                                    placeholder="Company Name" value="<?php echo e($editInfo->co_name); ?>">
                                <?php $__errorArgs = ['co_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>
                        <div class="form-row">
                            
                            <div class="col-md-6 mb-3 d-none">
                                <label for="validationCustom01">Customer Group Name :</label>
                                <select name="customergroup_id" class="form-control">
                                    <option value="0">Not Applicable</option>
                                    <?php $__currentLoopData = $customerGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($editInfo->customergroup_id == $value->id ? 'selected' : ''); ?>

                                            value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['customergroup_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="validationCustom01">Branch Name * :


                                </label>
                                <select class="form-control select2" name="branch_id">
                                    <option selected disabled value="">--Select--</option>

                                   <?php if(auth()->user()->role_id > 1): ?>
                                    <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>" <?php echo e(auth()->user()->branch_id == $value->id ? 'selected' :''); ?>><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?> 

                                  <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02"> E-mail :</label>
                                <input type="text" name="email" class="form-control" id="validationCustom02"
                                    placeholder="E-mail" value="<?php echo e($editInfo->email); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Phone * :</label>
                                <input type="text" name="phone" class="form-control" id="validationCustom01"
                                    placeholder="Phone" value="<?php echo e($editInfo->phone); ?>" required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Image</label>
                                    <div class="file-input-wrapper">
                                        <input type="file" id="voucher-input" name="image"
                                            accept="image/*,.pdf,.doc,.docx" class="<?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <label for="voucher-input" class="file-input-label">
                                            <i class="fa fa-cloud-upload"></i>
                                            <div>Click to select file</div>
                                            <small>Images, PDF, DOC files supported</small>
                                        </label>
                                        <div class="file-name" id="file-name"></div>
                                    </div>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <!-- Image Preview Container -->
                                    <div class="image-preview-container">
                                        <div class="image-preview" id="image-preview">
                                            <?php if($editInfo->logo && file_exists(public_path('/backend/logo/' . $editInfo->logo))): ?>
                                                <img id="preview-img"
                                                    src="<?php echo e(asset('/backend/logo/' . $editInfo->logo)); ?>" alt="Preview">
                                            <?php else: ?>
                                                <img id="preview-img" src="" alt="Preview"
                                                    style="display: none;">
                                            <?php endif; ?>
                                            <button type="button" class="image-remove-btn" id="remove-image">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02">Address* :</label>
                                <input name="address" class="form-control" id="validationCustom02" placeholder="Address"
                                    value="<?php echo e($editInfo->address); ?>" required>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                             <div class="col-md-6 mb-3">
                                <label for="validationCustom02">Customer Note *:</label>
                                <textarea name="customeNote" class="form-control" id="validationCustom02" placeholder="customerNote"
                                    value="" ><?php echo e($editInfo->customeNote); ?></textarea>
                                <?php $__errorArgs = ['customerNote'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom07">Bin :</label>
                                <input name="bin" class="form-control" id="validationCustom07" placeholder="Bin"
                                    value="<?php echo e($editInfo->bin); ?>">
                                <?php $__errorArgs = ['bin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <button class="btn btn-info" type="submit"><i class="fa fa-save"></i>&nbsp;Update</button>
                    </form>


                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>

    <script>
        $(document).ready(function() {
            <?php if($editInfo->logo): ?>
                <?php if(file_exists(public_path('/backend/logo/' . $editInfo->logo))): ?>
                    // Show existing image info
                    $('#file-name').html(`
                <div class="existing-file-info">
                    <i class="fa fa-check-circle"></i>
                    Current file: <?php echo e($editInfo->logo); ?>

                </div>
            `);
                    $('#image-preview').show();
                <?php else: ?>
                    // File doesn't exist, show error
                    $('#file-name').html(`
                <div class="existing-file-info" style="background: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                    <i class="fa fa-exclamation-triangle"></i>
                    Previous file not found: <?php echo e($editInfo->logo); ?>

                </div>
            `);
                <?php endif; ?>
            <?php endif; ?>

            $('#voucher-input').on('change', function(e) {
                const file = e.target.files[0];
                const fileName = $('#file-name');
                const imagePreview = $('#image-preview');
                const previewImg = $('#preview-img');

                if (file) {
                    // Show file name
                    fileName.text(file.name);

                    // Check if file is an image
                    if (file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            previewImg.attr('src', e.target.result);
                            previewImg.show();
                            imagePreview.show();
                        }
                        reader.readAsDataURL(file);
                    } else {
                        // For non-image files, show file info
                        imagePreview.hide();
                        fileName.html(
                            `<i class="fa fa-file"></i> ${file.name} (${(file.size / 1024).toFixed(2)} KB)`
                            );
                    }

                    // Update label text
                    $('.file-input-label').html(`
                <i class="fa fa-check-circle" style="color: #28a745;"></i>
                <div>File selected successfully</div>
                <small>Click to change file</small>
            `);
                }
            });

            // Remove image functionality
            $('#remove-image').on('click', function() {
                $('#voucher-input').val('');
                $('#image-preview').hide();
                $('#preview-img').hide();
                $('#file-name').text('');
                $('.file-input-label').html(`
            <i class="fa fa-cloud-upload"></i>
            <div>Click to select file</div>
            <small>Images, PDF, DOC files supported</small>
        `);
            });

            // Drag and drop functionality
            $('.file-input-label').on('dragover', function(e) {
                e.preventDefault();
                $(this).addClass('drag-over');
            });

            $('.file-input-label').on('dragleave', function(e) {
                e.preventDefault();
                $(this).removeClass('drag-over');
            });

            $('.file-input-label').on('drop', function(e) {
                e.preventDefault();
                $(this).removeClass('drag-over');

                const files = e.originalEvent.dataTransfer.files;
                if (files.length > 0) {
                    $('#voucher-input')[0].files = files;
                    $('#voucher-input').trigger('change');
                }
            });

        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/inventories/customer/edit.blade.php ENDPATH**/ ?>