<script type="text/javascript">
    /* -------------------------------------------------------------
     * initialise DataTable
     * ----------------------------------------------------------- */
    let table = $('#systemDatatable').DataTable({
        processing : true,
        serverSide : true,
        ajax : {
            url  : "<?php echo e(route('inventorySetup.supplier.dashboard')); ?>",
            type : 'GET',
            data : function (d) {
                d._token    = "<?php echo e(csrf_token()); ?>";
                d.from_date = $('#from_date').val();
                d.to_date   = $('#to_date').val();
            }
        },
        columns : [
            { data : 'id',        orderable : true },
            { data : 'name',      orderable : true },
             { data : 'address',      orderable : true },
            { data : 'totalDue',  orderable : true },
            { data : 'action',    orderable : false, searchable : false, class : 'text-nowrap' },
        ],
        fnDrawCallback : function () {
            $("[name='my-checkbox']").bootstrapSwitch({
                size     : 'small',
                onColor  : 'success',
                offColor : 'danger'
            });
        }
    });

    /* -------------------------------------------------------------
     * Data‑export buttons
     * ----------------------------------------------------------- */
    new $.fn.dataTable.Buttons(table, {
        buttons : ['copyHtml5', 'excelHtml5', 'csvHtml5', 'pdfHtml5', 'print']
    }).container().appendTo($('#buttons'));

    /* -------------------------------------------------------------
     * WHENEVER the date inputs change → redraw the table
     * ----------------------------------------------------------- */
    $('#from_date, #to_date').on('change', function () {
        table.draw();
    });
</script>
<?php /**PATH I:\jubayer\resources\views/backend/pages/inventories/supplier/supplierDueScript.blade.php ENDPATH**/ ?>