<?php $__env->startSection('title'); ?>
Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Inventory </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <?php if(helper::roleAccess('sale.sale.index')): ?>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('sale.sale.index')); ?>">Sale
                            List</a></li>
                    <?php endif; ?>
                    <li class="breadcrumb-item active"><span>Edit Sale</span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>


<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Sale Edit</h3>
                <div class="card-tools">
                    <?php if(helper::roleAccess('sale.sale.create')): ?>
                    <a class="btn btn-default" href="<?php echo e(route('sale.sale.create')); ?>"><i
                            class="fas fa-plus"></i>
                        Add New</a>
                    <?php endif; ?>
                    <span id="buttons"></span>

                    <a class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form class="needs-validation" method="POST" action="<?php echo e(route('sale.sale.update',$saletlist->id)); ?>"
                    novalidate>
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Invoice Number :</label>
                            <input class="bg-green form-control" readonly=""
                                style="padding: 5px; font-weight : bold; width: 100%"
                                value="<?php echo e($saletlist->invoice_no); ?> " for="validationCustom01">
                            <input type="hidden" name="invoice_no" class="form-control" id=""
                                value="<?php echo e($saletlist->invoice_no); ?>">
                        </div>
                        <div class="col-md-2 mb-3 d-none">
                            <label for="validationCustom01">Po Number :</label>
                            <input type="text" name="po_invoice" class="form-control" value="<?php echo e($saletlist->po_invoice); ?>">
                        </div>
                        <div class="col-md-2 mb-3 d-none">
                            <label>Po Date:</label>
                            <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                                <input type="text" name="po_date" data-toggle="datetimepicker"
                                    value="<?php echo e(date('YYYY-mm-dd')); ?>" class="form-control datetimepicker-input"
                                    data-target="#reservationdate1" />
                                <div class="input-group-append" data-target="#reservationdate1"
                                    data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                            <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label>Date:</label>
                            <div class="input-group date" id="reservationdate" data-target-input="nearest">
                                <input type="text" name="date" data-toggle="datetimepicker"
                                    value="<?php echo e($saletlist->date); ?>" class="form-control datetimepicker-input"
                                    data-target="#reservationdate" />
                                <div class="input-group-append" data-target="#reservationdate"
                                    data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                            <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Branch * :</label>

                            <select class="form-control select2" id="branch_id" name="branch_id">
                                <option selected disabled value="">--Select Branch--</option>
                                <?php $__currentLoopData = $branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value->id); ?>" <?php echo e($saletlist->branch_id == $value->id ? "selected":""); ?> >
                                    <?php echo e($value->branchCode . ' - ' . $value->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        

                        
                        <div class="col-md-2 mb-3">
                            <label for="ledger_id">Ledger * :

                                <button type="button" class="btn btn-sm btn-primary ml-2" data-toggle="modal"
                                data-target="#addCustomerModel">
                                +
                            </button>
                            </label>
                            <select class="form-control select2" name="ledger_id" id="ledger_id">
                                <option selected disabled value="">--Select Ledger--</option>
                                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.account','data' => ['setAccounts' => $ledgers,'selectVal' => $saletlist->ledger_id]]); ?>
<?php $component->withName('account'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['setAccounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($ledgers),'selectVal' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($saletlist->ledger_id)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['ledger_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Payment Type * :</label>
                            <br>
                            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                
                                
                                <label class="btn bg-olive">
                                    <input type="radio" name="payment_type" value="Due"
                                        onchange="getCustomerBalance('Due')" <?php echo e($saletlist->payment_type ==
                                    "Due" ? "checked":""); ?> id="option3" autocomplete="off"> Due
                                </label>
                                
                            </div>
                            <input type="hidden" id="paymentType">
                            <input type="hidden" id="expireData">
                            <input type="hidden" id="paymentypeValue" value="<?php echo e($saletlist->payment_type); ?>">
                        </div>
                        <table class=" table-responsive table table-bordered">
                            <tr>
                                <td>
                                    <div class="col-md-9 float-left ">
                                        Sales Item
                                    </div>
                                    <div class="col-md-3 float-right">
                                        Payment Calculation
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px!important;">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="col-md-12 float-left">
                                                <div class="panel panel-default">
                                                    <div class="panel-body">

                                                        <table class="table table-bordered table-hover tableAddItem"
                                                            id="show_item">
                                                            <thead>
                                                                <tr>
                                                                   
                                                                    <th nowrap style="width:15%" align="center"
                                                                        id="">
                                                                        <strong>Product <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th nowrap style="width:11%" align="center">
                                                                        <strong>Team <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th nowrap style="width:11%" align="center">
                                                                        <strong>Fabrics <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th nowrap style="width:11%" align="center">
                                                                        <strong>Quantity <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    
                                                                    <th nowrap style="width:12%" align="center">
                                                                        <strong>Unit
                                                                            Price(BDT) <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th nowrap style="width:13%" align="center">
                                                                        <strong>Total Price(BDT) <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th align="center" style="width:5%">
                                                                        <strong>Action</strong>
                                                                    </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                   

                                                                    
                                                                    <td id="product_td">
                                                                        
                                                                              <select class="select2 form-control proName" id="productID"
                                                                    data-placeholder="Search Product" onchange="getUnitPrice(this.value)">
                                                                    <option value="">---Select Product---</option>
                                                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($product->id); ?>" proName="<?php echo e($product->name); ?>">
                                                                            <?php echo e($product->name); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                        <span class="text-success purchaseprice"></span>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control team"
                                                                            id="team">
                                                                    </td>
                                                                    
                                                                    <td>
                                                                        <select class="select2 form-control purchasetype"
                                                                            name="fabrics[]"
                                                                            onchange="getUnitPrice(this.value)">
                                                                            <option selected disabled value="">--Select Fabrics--</option>
                                                                            <?php $__currentLoopData = $fabricType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>


                                                                        <span
                                                                            class="text-success purchasetypeerror"></span>
                                                                    </td>


                                                                    
                                                                    <td>
                                                                        
                                                                        <input type="text" class="form-control qty"
                                                                            id="qty" onkeyup="qtyPriceCal();"
                                                                            placeholder="0">
                                                                    </td>

                                                                    

                                                                    

                                                                    
                                                                    <td>
                                                                        <input type="text"
                                                                            class="form-control text-right  unitprice"
                                                                            id="unitpice" onkeyup="qtyPriceCal();"
                                                                            placeholder="0.00">
                                                                    </td>

                                                                    
                                                                    <td>
                                                                        <input type="text"
                                                                            class="form-control text-right ttlamount total"
                                                                            id="total" placeholder="0.00"
                                                                            readonly="readonly">
                                                                    </td>

                                                                    <td>
                                                                        <a id="add_item"
                                                                            class="btn btn-info form-control"
                                                                            href="javascript:;" title="Add Item">
                                                                            <i class="fa fa-plus"></i>
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                                <?php $__currentLoopData = $saledetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                <tr class="new_item<?php echo e($value->product_id); ?>">
                                                                    
                                                                    <td align="right">
                                                                        <?php echo e($value->product->name ?? 'N/A'); ?><input
                                                                            type="hidden" class="add_quantity"
                                                                            name="proName[]"
                                                                            value="<?php echo e($value->product_id); ?>">
                                                                    </td>

                                                                    <td align="right">
                                                                        <?php echo e($value->team); ?>

                                                                    <input type="hidden"  name="team[]" value="<?php echo e($value->team); ?>">

                                                                    </td>
                                                                    <td align="right">
                                                                        <?php echo e($value->fabricDetails->name ?? ""); ?>

                                                                    <input type="hidden"  name="purchasetype[]" value="<?php echo e($value->fabrics); ?>">
                                                                    </td>

                                                                <td align="right">
                                                                <input type="number" class="update-qty form-control" name="qty[]" 
                                                                    value="<?php echo e($value->qty); ?>" 
                                                                    data-product-id="<?php echo e($value->product_id); ?>" 
                                                                    data-unit-price="<?php echo e($value->rate); ?>"
                                                                    min="1" step="1">
                                                            </td>

                                                                    <td align="right"><?php echo e($value->rate); ?><input
                                                                            type="hidden"
                                                                            class="ttlunitprice unitparice"
                                                                            name="unitprice[]"
                                                                            value="<?php echo e($value->rate); ?>">
                                                                    </td>
                                                                    <?php
                                                                    $totale = $value->price;
                                                                    ?>
                                                                    <td align="right"><?php echo e($totale); ?><input type="hidden"
                                                                            class="grandtotal" name="price[]"
                                                                            value="<?php echo e($totale); ?>">
                                                                    </td>
                                                                    <td><a del_id="<?php echo e($key + 1); ?>"
                                                                            class="delete_item btn form-control btn-danger"
                                                                            href="javascript:;" title=""><i
                                                                                class="fa fa-times"></i></a>
                                                                    </td>
                                                                </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <td align="right"><strong>Sub-Total(BDT)</strong>
                                                                    </td>
                                                                    <td align="right"><strong class=""></strong>
                                                                    </td>
                                                                    <td align="right"><strong class=""></strong>
                                                                    </td>
                                                                    <td align="
                                                                    right">
                                                                    <strong
                                                                    class="ttlqty"><?php echo e($saledetails->sum('qty')); ?></strong>
                                                                </td>
                                                               
                                                                <td align="right"><strong
                                                                    class="ttlunitprice"><?php echo e($saledetails->sum('rate')); ?></strong>
                                                                </td>
                                                                    <td align="right"><strong
                                                                            class="grandtotal"><?php echo e($saledetails->sum('price')); ?></strong>
                                                                    </td>
                                                                     <td align="right"><strong class=""></strong>
                                                                    </td>
                                                                </tr>
                                                                 
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6 float-right">
                                                <div class="panel  panel-default">
                                                    <div class="panel-body">

                                                        <table class="table table-bordered table-hover ">
                                                            <tbody>
                                                                <tr>
                                                                    <td nowrap align="right"><strong>Total
                                                                        </strong>
                                                                    </td>
                                                                    <td align="right"> <strong id="gtoal"
                                                                            class="grandtotal"><?php echo e($saledetails->sum('price')); ?>.00</strong>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td nowrap align="right">
                                                                        <strong>Previous Due </strong>
                                                                    </td>
                                                                    <td align="right"> <strong id="previous_due"><?php echo e($saletlist->previouse_due_amount); ?></strong>
                                                                        <input type="hidden" id="previouse_due_amount" value="<?php echo e($saletlist->previouse_due_amount); ?>" name="previouse_due_amount" >
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td nowrap align="right">
                                                                        <strong>Discount ( - )
                                                                        </strong>
                                                                    </td>
                                                                    <td><input type="text" autocomplete="off"
                                                                            onkeyup="discountCalculation(this.value)"
                                                                            id="disCount" style="text-align: right"
                                                                            name="discount"
                                                                            value="<?php echo e($saletlist->discount); ?>"
                                                                            class="form-control" placeholder="0.00"
                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td nowrap align="right">
                                                                        <strong>Carrying Cost ( + )
                                                                        </strong>
                                                                    </td>
                                                                    <td><input type="text"
                                                                            autocomplete="off"
                                                                            onkeyup="carrying_cost_Calculation(this.value)"
                                                                            id="carrying_cost"
                                                                            style="text-align: right"
                                                                            name="carrying_cost"
                                                                            value="<?php echo e($saletlist->carrying_cost); ?>"
                                                                            class="form-control"
                                                                            placeholder="0.00"
                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td nowrap align="right">
                                                                        <strong>Labor bill ( + )
                                                                        </strong>
                                                                    </td>
                                                                    <td><input type="text"
                                                                            autocomplete="off"
                                                                            onkeyup="labor_bill_Calculation(this.value)"
                                                                            id="labor_bill"
                                                                            value="<?php echo e($saletlist->labor_bill); ?>"
                                                                            style="text-align: right"
                                                                            name="labor_bill"
                                                                            class="form-control"
                                                                            placeholder="0.00"
                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td nowrap align="right">
                                                                        <strong>Advance
                                                                        </strong>
                                                                    </td>
                                                                    <td>
                                                                        <select name="advance_ledger_id" class="form-control select2">
                                                                            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.account','data' => ['setAccounts' => $accounts]]); ?>
<?php $component->withName('account'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['setAccounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($accounts)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                                                         </select>
                                                                     <input type="text"
                                                                            autocomplete="off"
                                                                            onkeyup="advance_amount(this.value)"
                                                                            id="advance"
                                                                            style="text-align: right"
                                                                            name="advance"
                                                                            value="<?php echo e($saletlist->advance); ?>"
                                                                            class="form-control"
                                                                            placeholder="0.00"
                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                    </td>
                                                                </tr>
                                                                <?php
                                                                $discount = $saledetails->sum('price') - $saletlist->discount;
                                                                ?>
                                                                <tr id="netTotal">
                                                                    <td nowrap align="right"><strong>Net Total</strong></td>
                                                                    <td align="right"><strong id="ntotal"
                                                                            class="grandtotal"><?php echo e($discount); ?>.00</strong>
                                                                    </td>
                                                                </tr>
                                                                <tr id="account_id" >
                                                                    <td nowrap align="right">
                                                                        <strong>Account <span
                                                                                style="color:red;"> * </span></strong>
                                                                    </td>
                                                                    <td>
                                                                        <select name="account_id" class="form-control select2">
                                                                            <option selected value="0">Due</option>
                                                                            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.account','data' => ['setAccounts' => $accounts]]); ?>
<?php $component->withName('account'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['setAccounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($accounts)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                                                         </select>
                                                                    </td>
                                                                </tr>
                                                                <tr class="partisals d-none">
                                                                    <td nowrap align="right"><strong>Payment
                                                                            ( -
                                                                            )<span style="color:red;"> *
                                                                            </span></strong>
                                                                    </td>
                                                                    <td><input type="text" id="payment"
                                                                            onkeyup="paymentCalculation(this.value)"
                                                                            style="text-align: right"
                                                                            name="partialPayment" readonly
                                                                            value="<?php echo e($saletlist->partialPayment); ?>"
                                                                            class="form-control" autocomplete="off"
                                                                            placeholder="0.00"
                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                    </td>
                                                                    <!-- <input type="hidden" id="duePayment" style="text-align: right" name="duePayment" value="" readonly class="form-control" placeholder="0.00" /> -->
                                                                </tr>

                                                                <tr>
                                                                    <td nowrap align="right"><strong>Total
                                                                            Due</strong>
                                                                    </td>
                                                                    <td align="right"><strong id="totalDue"
                                                                            class="grandtotal finalDue"><?php echo e($discount
                                                                            -
                                                                            $saletlist->partialPayment); ?>.00</strong>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 float-right">
                                                <div class="panel">
                                                    <div class="panel-body">
                                                        <table class="table ">
                                                            <tr>
                                                                <td>
                                                                    <textarea style="
                                                                                    border:none;" cols="157"
                                                                        class="form-control" name="narration"
                                                                        placeholder="Note......" type="text"></textarea>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>

                                </td>
                            </tr>
                            <tr>

                            </tr>
                            <tr>
                                <td>
                                    <div class="clearfix"></div>
                                    <div class="clearfix form-actions float-right">
                                        <div class="col-md-offset-1 col-md-10">
                                            <button class="btn btn-info" id="subMitButton" type="submit">
                                                Save
                                            </button>
                                            &nbsp; &nbsp; &nbsp;

                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>





                    </div>

                </form>
            </div>
            <!-- /.card-body -->
            <div class="card-footer">

            </div>
        </div>
    </div>
    <!-- /.col-->
</div>

<div class="modal fade" id="addCustomerModel" tabindex="-1" role="dialog" aria-labelledby="addCustomerModelLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addCustomerModelLabel">Add Customer</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" id="addCustomerFOrm" action="<?php echo e(route('sale.sale.quiceAddCustomer')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom01">Company Name *:</label>
                                <input type="text" name="co_name" class="form-control" id="validationCustom01" placeholder="Company Name" value="<?php echo e(old('co_name')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom01">Customer Group Name *:</label>
                                <select name="customergroup_id" class="form-control select2">
                                    <option value="0">Not Applicable</option>
                                    <?php $__currentLoopData = $customerGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>"><?php echo e($data->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom01">Contact Person:</label>
                                <input type="text" name="name" class="form-control" id="validationCustom01" placeholder="Contact Person" value="<?php echo e(old('name')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom02">E-mail:</label>
                                <input type="text" name="email" class="form-control" id="validationCustom02" placeholder="E-mail" value="<?php echo e(old('email')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom01">Phone:</label>
                                <input type="text" name="phone" class="form-control" id="validationCustom01" placeholder="Phone" value="<?php echo e(old('phone')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom02">Address:</label>
                                <input name="address" class="form-control" id="validationCustom02" placeholder="Address" value="<?php echo e(old('address')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validationCustom07">Bin:</label>
                                <input name="bin" class="form-control" id="validationCustom07" placeholder="Bin" value="<?php echo e(old('bin')); ?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Customer</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">

$(document).ready(function() {
            // Supplier  Create
            $('#addCustomerFOrm').on('submit', function(e) {
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: $(this).attr('action'),
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            $('#addCustomerModel').modal('hide');
                            $('select[name="ledger_id"]').append(
                                `<option value="${response.accounts.id}" selected>${response.accounts.account_name}</option>`
                            );
                        } else {
                            alert('Error adding Unit');
                        }
                    },
                    error: function(error) {
                        alert('An error occurred');
                    }
                });
                $("button[type='submit']").prop('disabled', false);
            });
        });
   

    $(document).ready(function () {
        $('#cty_size, #qty').on('input', function () {
            let ctyval = $('#cty_size').val();
            let qty = $('#qty').val();
            let gas_qty = ctyval * qty;
            $('#gas_qty').val(gas_qty);
        })

        var findqtyamount = function () {

            var ttlqty = 0;
            $.each($('.ttlqty'), function () {
                qty = $(this).val();
                qty = Number(qty);
                ttlqty += qty;
            });
            $('.ttlqty').text(parseFloat(ttlqty).toFixed(2));

        };

        var findunitamount = function () {
            var ttlunitprice = 0;
            $.each($('.ttlunitprice'), function () {
                unitprice = $(this).val();
                unitprice = Number(unitprice);
                ttlunitprice += unitprice;
            });
            $('.ttlunitprice').text(parseFloat(ttlunitprice).toFixed(2));
        };

        var findgrandtottal = function () {
            var grandtotal = 0;
            $.each($('.grandtotal'), function () {
                total = $(this).val();
                total = Number(total);
                grandtotal += total;
            });
            $('.grandtotal').text(parseFloat(grandtotal).toFixed(2));
            var paymentType = $('input[name="payment_type"]:checked').val();
            if (paymentType == "Cash") {
                $('#payment').val(parseFloat(grandtotal).toFixed(2));
                paymentCalculation(parseFloat(grandtotal));
            }
        };

     $("#add_item").click(function() {
    let productId = $('#productID option:selected').val();
    let productName = $('#productID option:selected').text();
    let team = $('#team').val();
    let purchaseTypeVal = $('.purchasetype option:selected').val();
    let purchaseTypeText = $('.purchasetype option:selected').text();
    let qty = $('#qty').val();
    let unitPrice = $('#unitpice').val();
    let total = $('#total').val();

    // Validation
    if (!productId) {
        alertMessage.error("Please select a product");
        return false;
    }
    if (!purchaseTypeVal) {
        alertMessage.error("Please select a fabric type");
        return false;
    }
    if (!qty || qty <= 0) {
        alertMessage.error("Quantity must be greater than 0");
        return false;
    }

    // Check for duplicate product+fabric combination
    var exists = false;
    $('#show_item tbody tr:not(:first)').each(function() {
        var existingProId = $(this).find('input[name="proName[]"]').val();
        var existingType = $(this).find('input[name="purchasetype[]"]').val();
        if (existingProId === productId && existingType === purchaseTypeVal) {
            exists = true;
            return false;
        }
    });

    if (exists) {
        alertMessage.error('This product with same fabric type already exists');
        return false;
    }

    // Add new row
    $("#show_item tbody").append(
        '<tr class="new_item' + productId + '">' +
            '<td align="right">' +
                productName +
                '<input type="hidden" name="proName[]" value="' + productId + '">' +
            '</td>' +
            '<td align="right">' +
                team +
                '<input type="hidden" name="team[]" value="' + team + '">' +
            '</td>' +
            '<td align="right">' +
                purchaseTypeText +
                '<input type="hidden" name="purchasetype[]" value="' + purchaseTypeVal + '">' +
            '</td>' +
            '<td align="right">' +
                '<input type="number" class="update-qty form-control" name="qty[]" value="' + qty + '" ' +
                'data-product-id="' + productId + '" data-unit-price="' + unitPrice + '" min="1">' +
            '</td>' +
            '<td align="right">' +
                unitPrice +
                '<input type="hidden" class="unitparice" name="unitprice[]" value="' + unitPrice + '">' +
            '</td>' +
            '<td align="right" >' +
                total +
                '<input type="hidden" class="grandtotal total" name="price[]" value="' + total + '">' +
            '</td>' +
            '<td>' +
                '<a del_id="' + productId + '" class="delete_item btn form-control btn-danger" href="javascript:;">' +
                    '<i class="fa fa-times"></i>' +
                '</a>' +
            '</td>' +
        '</tr>'
    );

    // Clear input fields
    $('#productID').val('').trigger('change');
    $('#team').val('');
    $('.purchasetype').val('');
    $('#qty').val('');
    $('#unitpice').val('');
    $('#total').val('');

    // Update all totals
    recalculateAllTotals();
});

        $(document).on('click', '.delete_item', function () {
            // if (confirm("Are you sure?")) {
            //     var id = $(this).attr("del_id");
            //     $('.new_item' + id).remove();
            //     findqtyamount();
            //     findunitamount();
            //     findgrandtottal();
            //     checkDepositAndCreditBalance();
            // }

            let deleteitem = () => {
                var id = $(this).attr("del_id");
                $('.new_item' + id).remove();
                findqtyamount();
                findunitamount();
                findgrandtottal();
                checkDepositAndCreditBalance();
                advance_amount();
                recalculateTotals();
            }
            alertMessage.confirm('You want to remove this', deleteitem);
        });
    });



  function showAlert(message, type = 'info') {
            // Implement your alert system here
            if (typeof alertMessage !== 'undefined') {
                alertMessage[type](message);
            } else {
                alert(message);
            }
        }

// Handle quantity changes
$(document).on('input', '.update-qty', function() {
    var qty = parseFloat($(this).val()) || 0;
    var unitPrice = parseFloat($(this).data('unit-price')) || 0;
    var rowTotal = qty * unitPrice;
    
    // Update current row
    $(this).closest('tr').find('.row-total').text(rowTotal.toFixed(2));
    $(this).closest('tr').find('.row-grandtotal').val(rowTotal.toFixed(2));
    
    // Update all totals
    recalculateAllTotals();
});

// Handle discount, carrying cost, etc. changes
$(document).on('input', '#disCount, #carrying_cost, #labor_bill, #advance', function() {
    recalculateAllTotals();
});

// Handle delete item
$(document).on('click', '.delete_item', function() {
    var id = $(this).attr("del_id");
    $('.new_item' + id).remove();
    recalculateAllTotals();
});

function updateRowTotal(inputElement) {
    var qty = parseFloat(inputElement.val()) || 0;
    var unitPrice = parseFloat(inputElement.data('unit-price')) || 0;
    var productId = inputElement.data('product-id');
    var newTotal = qty * unitPrice;
    
    // Update the row
    var row = inputElement.closest('tr');
    row.find('input[name="price[]"]').val(newTotal);
    row.find('td').eq(5).text(newTotal.toFixed(2));
    
    // Update all totals
    recalculateTotals();
}

function recalculateAllTotals() {
    var totalQty = 0;
    var totalUnitPrice = 0;
    var grandTotal = 0;
    
    // Calculate row totals and sum all values
    $('#show_item tbody tr:not(:first)').each(function() {
        var qty = parseFloat($(this).find('.update-qty').val()) || 0;
        var unitPrice = parseFloat($(this).find('.update-qty').data('unit-price')) || 0;
        var rowTotal = qty * unitPrice;
        
        // Update row total display
        $(this).find('.row-total').text(rowTotal.toFixed(2));
        $(this).find('.row-grandtotal').val(rowTotal.toFixed(2));
        
        // Add to sums
        totalQty += qty;
        totalUnitPrice += unitPrice;
        grandTotal += rowTotal;
    });
    
    // Update footer totals
    $('.ttlqty').text(totalQty.toFixed(2));
    $('.ttlunitprice').text(totalUnitPrice.toFixed(2));
    $('.grandtotal').text(grandTotal.toFixed(2));
    
    // Update right panel totals
    $('#gtoal').text(grandTotal.toFixed(2));
    
    // Calculate net total with adjustments
    var discount = parseFloat($('#disCount').val()) || 0;
    var carrying_cost = parseFloat($('#carrying_cost').val()) || 0;
    var labor_bill = parseFloat($('#labor_bill').val()) || 0;
    var advance = parseFloat($('#advance').val()) || 0;
    var previous_due = parseFloat($('#previouse_due_amount').val()) || 0;
    
    var netTotal = grandTotal - discount + carrying_cost + labor_bill + previous_due - advance;
    $('#ntotal').text(netTotal.toFixed(2));
    $('#totalDue').text(netTotal.toFixed(2));
    
    // Update payment if cash
    if ($('input[name="payment_type"]:checked').val() == "Cash") {
        $('#payment').val(netTotal.toFixed(2));
        paymentCalculation(netTotal);
    }
}

// Update delete handler
// $(document).on('click', '.delete_item', function() {
//     let deleteitem = () => {
//         var id = $(this).attr("del_id");
//         $('.new_item' + id).remove();
//         recalculateTotals();
//         checkDepositAndCreditBalance();
//         advance_amount();
//     }
//     alertMessage.confirm('You want to remove this', deleteitem);
// });
        
    function checkDepositAndCreditBalance() {

        var paymentType = $("#paymentType").val();

        if (paymentType == '') {
            paymentType = 'Cash';
        }

        console.log(paymentType);
        var customer_currentBalance = $("#customer_currentBalance").val();
        // var totalDue = document.getElementById("totalDue").innerText;

        var totalDue = $("#totalDue").text();
        var expireDatas = $("#expireData").val();


        var todaysDate = new Date().toISOString().slice(0, 10);

        if (expireDatas == '') {
            expireDatas = todaysDate;
        }
        var btn = document.getElementById('subMitButton');
          if (paymentType == 'Cash') {
            console.log('3');
            btn.disabled = false;
        } else {
            console.log('4');
            btn.disabled = false;
        }

    }

    function gamount(){
        var gtoal = parseFloat(document.getElementById("gtoal").innerText);
        var carrying_cost = parseFloat($("#carrying_cost").val());
        var discount = parseFloat($("#disCount").val());
        var labor_bill = parseFloat($("#labor_bill").val());
        var advance = parseFloat($("#advance").val());
        var previouse_due_amount = parseFloat($("#previouse_due_amount").val());
        return ((gtoal || 0) + (carrying_cost || 0) + (previouse_due_amount || 0) + (labor_bill || 0)) - (discount || 0) - (advance || 0);
    }
    function discountCalculation(amount) {
        var gtoal = document.getElementById("gtoal").innerText;
        var carrying_cost =$("#carrying_cost").val();

        if (parseFloat(gtoal) < parseFloat(amount)) {
            alertMessage.error("Discount Can'n Greater than Total amount");
            $('#disCount').val('');
            $('#ntotal').text(parseFloat(gtoal).toFixed(2));
            $('#totalDue').text(parseFloat(gtoal).toFixed(2));
            var paymentType = $('input[name="payment_type"]:checked').val();
            if (paymentType == "Cash") {
                $('#payment').val(parseFloat(gtoal));
                paymentCalculation(parseFloat(gtoal));
            }
            return;
        }

        var afterDiscount = gamount();
        $('#ntotal').text(parseFloat(afterDiscount).toFixed(2));
        $('#totalDue').text(parseFloat(afterDiscount).toFixed(2));

        var paymentType = $('input[name="payment_type"]:checked').val();
        if (paymentType == "Cash") {
            $('#payment').val(parseFloat(afterDiscount));
            paymentCalculation(parseFloat(afterDiscount));
        }
    }
    function carrying_cost_Calculation(amount) {

        var gtoal = document.getElementById("gtoal").innerText;
        var discount = $("#disCount").val();
        var afterCarryingCost =  gamount();
        $('#ntotal').text(parseFloat(afterCarryingCost).toFixed(2));
        $('#totalDue').text(parseFloat(afterCarryingCost).toFixed(2));

    }
    function labor_bill_Calculation(amount) {
        var gtoal = document.getElementById("gtoal").innerText;
        var afterLaborBill =  gamount();
        $('#ntotal').text(parseFloat(afterLaborBill).toFixed(2));
        $('#totalDue').text(parseFloat(afterLaborBill).toFixed(2));
    }
    function advance_amount(amount) {
            var gtoal = document.getElementById("gtoal").innerText;
            var afterAdvance = gamount();
            $('#ntotal').text(parseFloat(afterAdvance).toFixed(2));
            $('#totalDue').text(parseFloat(afterAdvance).toFixed(2));
    }

    function paymentCalculation(payamount) {
        var ntotal = document.getElementById("ntotal").innerText;
        var totalDue = ntotal - payamount;
        $('.finalDue').text(parseFloat(totalDue).toFixed(2));
    }

    function qtyPriceCal() {
        var qty = $('#qty').val();
        var unitpice = $('#unitpice').val();
        var vat = parseFloat($('#vat').val()) || 0;
        var currentStock = $('#currentStock').val();
        if (parseFloat(qty) > currentStock) {
            $('.ttlamount').val('');
            $('#qty').val('');
            // lert('The desired product stock is not available');
            alertMessage.error('The desired product stock is not available.');
        } else {
            var totalWithoutVAT = unitpice * qty;
            var vatAmount = (vat > 0) ? (vat / 100) * totalWithoutVAT : 0;
            var totalWithVAT = totalWithoutVAT + vatAmount;
            var ttlqtys = document.getElementById('total').value = totalWithVAT.toFixed(2);
        }
    }

    function getProductList(cat_id) {

        var branch_id = $('#branch_id').val();

        if (branch_id == null) {
            alertMessage.error('Branch Are not selected');
            return;
        }
        $.ajax({
            "url": "<?php echo e(route('sale.sale.getProductListForSale')); ?>",
            "type": "GET",
            cache: false,
            data: {
                "_token": "<?php echo e(csrf_token()); ?>",
                cat_id: cat_id,
                branch_id: branch_id
            },
            success: function (data) {
                $('#productID').select2();
                $('#productID option').remove();
                $('#productID').append($(data));
                $("#productID").trigger("select2:updated");
            }
        });
    }

    function getCustomerBalance(payment_type) {
        var customer_id = $('#customer_id').val();
        $("#paymentType").val(payment_type);

        if (payment_type == 'Cash') {
            $('#account_id').show();
            $('#netTotal').show();
            $('.partisals').show();
            calculatetotal();
        } else {
            calculatetotal();
            var discount = $('#disCount').val();
            discountCalculation(discount);
            // $('.partisals').css('display', 'none');
            // $('#account_id').css('display', 'none');
            // $('#netTotal').css('display', 'none');
        }

        $.ajax({
            "url": "<?php echo e(route('sale.sale.getCustomerBalance')); ?>",
            "type": "GET",
            cache: false,
            dataType: "json",
            data: {
                "_token": "<?php echo e(csrf_token()); ?>",
                customer_id: customer_id,
                payment_type: payment_type
            },
            success: function (data) {

                if (payment_type == 'Cash') {
                    $("#customer_currentBalance").val('');
                } else {
                    $("#customer_currentBalance").val(data.finalBalance);
                    $("#expireData").val(data.expireData);
                }

            }
        });
    }

    var calculatetotal = function () {
        var grandtotal = 0;
        $.each($('.grandtotal'), function () {
            total = $(this).val();
            total = Number(total);
            grandtotal += total;
        });

        if (parseFloat(grandtotal) > 0) {
            $('.grandtotal').text(parseFloat(grandtotal).toFixed(2));
            var paymentType = $('input[name="payment_type"]:checked').val();
            if (paymentType == "Cash") {
                $('#payment').val(parseFloat(grandtotal).toFixed(2));
                paymentCalculation(parseFloat(grandtotal));
            }
        }
    };

    var payTypeID = $('#paymentypeValue').val();
    getCustomerBalance(payTypeID);

    // function getUnitPrice(v) {
    //     let branch_id = $('#branch_id option:selected').val();
    //     let purchasetype = $('.purchasetype option:selected').val();
    //     let productId = $('#productID option:selected').val();
    //     $.ajax({
    //         "url": "<?php echo e(route('sale.sale.saleunitPrice')); ?>",
    //         "type": "GET",
    //         cache: false,
    //         data: {
    //             "_token": "<?php echo e(csrf_token()); ?>",
    //             productId: productId
    //         },
    //         success: function (data) {
    //         }
    //     });

    //     $.ajax({
    //         "url": "<?php echo e(route('sale.sale.getProductStock')); ?>",
    //         "type": "GET",
    //         cache: false,
    //         data: {
    //             "_token": "<?php echo e(csrf_token()); ?>",
    //             productId: productId,
    //             type: purchasetype,
    //             branch_id: branch_id,

    //         },
    //         success: function (data) {
    //             $("#currentStock").val(data);
    //         }
    //     });
    // }

      function getUnitPrice(v) {
            let branch_id = $('#branch_id option:selected').val();
             let sub_branch_id = $('#sub_warehouse_id option:selected').val();
            let purchasetype = $('.purchasetype option:selected').val();
            let productId = $('#productID option:selected').val();
            $.ajax({
                "url": "<?php echo e(route('sale.sale.saleunitPrice')); ?>",
                "type": "GET",
                cache: false,
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    'productId': productId,
                },
                success: function(data) {
                    console.log(data);
                    $("#unitpice").val(data.sale_price);
                    $(".purchaseprice").html("Last PP :" + data.lastPurchasePrice);

                }
            });

            $.ajax({
                "url": "<?php echo e(route('sale.sale.getProductStock')); ?>",
                "type": "GET",
                cache: false,
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    productId: productId,
                    type: purchasetype,
                    branch_id: branch_id,
                    sub_branch_id: sub_branch_id,

                },
                success: function(data) {
                    $("#currentStock").val(data);
                }
            });
        }
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\XAMPP\htdocs\jubayer\resources\views/backend/pages/sale/edit.blade.php ENDPATH**/ ?>