<script type="text/javascript">
    let table = $('#systemDatatable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo e(route('settings.expense.dataProcessingExpense')); ?>",
            "dataType": "json",
            "type": "GET",
            "data": {
                "_token": "<?= csrf_token() ?>"
            }
        },
        "columns": [{
            "data": "id",
            "orderable": true
        },
        {
            "data": "date",
            "orderable": true
        },
        {
            "data": "chartofaccount_id",
            "orderable": true
        },
        {
            "data": "branch_id",
            "orderable": true
        },
        {
            "data": "expensecategorie_id",
            "orderable": true

        },
        {
            "data": "expensesubcategorie_id",
            "orderable": true

        },
        {
            "data": "amount",
            "orderable": true
        },
        {
            "data": "note",
            "orderable": true
        },
        {
            "data": "action",
            "class": 'text-nowrap',
            "searchable": false,
            "orderable": false
        },
        ],

        "fnDrawCallback": function () {
            $("[name='my-checkbox']").bootstrapSwitch({
                size: "small",
                onColor: "success",
                offColor: "danger"
            });
        },

    });


    var buttons = new $.fn.dataTable.Buttons(table, {
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print',
        ]
    }).container().appendTo($('#buttons'));
</script><?php /**PATH I:\jubayer\resources\views/backend/pages/settings/expense/script.blade.php ENDPATH**/ ?>