
<?php $__env->startSection('title'); ?>
    Quick Sales List - <?php echo e(''); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('sale.sale.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('sale.sale.index')); ?>">Sale</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Sale List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title"> Quick Sale List</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('sale.sale.create')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('quicksales.create')); ?>"><i
                                    class="fas fa-plus"></i>Add
                                New</a>
                        <?php endif; ?>
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer</th>
                                    <th>Date</th>
                                    <th>Phone</th>
                                    <th>Grand Total</th>
                                    <th>Discount</th>
                                    <th>Shipping Cost</th>
                                    <th>Paid Amount</th>
                                    <th>Total Due</th>
                                    <th>Payment Status</th>
                                    <th>Delivery Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            
                            <tbody>
                                <?php $__currentLoopData = $quickSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e('N/A'); ?></td>
                                        <td><?php echo e($sale->date); ?></td>
                                        <td><?php echo e('N/A'); ?></td>
                                        <td><?php echo e(number_format($sale->total_amount, 0)); ?></td>
                                        <td><?php echo e(number_format($sale->discount, 0)); ?></td>
                                        <td><?php echo e(number_format($sale->shipping_charge, 0)); ?></td>
                                        <td><?php echo e(number_format($sale->received_amount, 0)); ?></td>
                                        <td><?php echo e(number_format($sale->due_balance, 0)); ?></td>
                                        <td><?php echo e($sale->payment_status); ?></td>
                                        <td><?php echo e($sale->delivery_status); ?></td>
                                        <td class=" d-flex">
                                            <a href="<?php echo e(route('quick.sales.show', $sale->id)); ?>"
                                                class="btn btn-info ">Show</a>
                                            <a href="<?php echo e(route('quick.sales.edit', $sale->id)); ?>"
                                                class="btn btn-primary  ml-2">Edit</a>
                                            <form action="<?php echo e(route('quick.sales.delete', $sale->id)); ?>" method="POST"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger  ml-2">
                                                    DELETE
                                                </button>
                                            </form>
                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer</th>
                                    <th>Date</th>
                                    <th>Phone</th>
                                    <th>Grand Total</th>
                                    <th>Discount</th>
                                    <th>Shipping Cost</th>
                                    <th>Paid Amount</th>
                                    <th>Total Due</th>
                                    <th>Payment Status</th>
                                    <th>Delivery Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\XAMPP\htdocs\jubayer\resources\views/backend/pages/quick_sales/quicksaleslist.blade.php ENDPATH**/ ?>