<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>ISP Billing Software</title>
    <meta name="description" content="ISP Billing Software Login Page">
    <meta name="keywords" content="ISP, Billing, Software, Login">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        body {
            background-image:linear-gradient(310deg, #00fe78, #80ff83);
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .wrapper {
            display: flex;
            justify-content: space-between;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
            max-width: 937px;
            width: 40%;
            overflow: hidden;
            flex-direction: row;
        }

        .left,
        .right {
            padding: 8px;
            width: 100%;
        }

        .contact-card {
            background-color: #fff;
            border-radius: 10px;
            padding: 10px;
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
            text-align: left;
        }

        .contact-card img {
            max-width: 120px;
            margin-bottom: 20px;
        }

        .contact-card p {
            margin: 10px 0;
            font-size: 14px;
            color: #666;
        }

        .contact-card p i {
            color: #9055ff;
            margin-right: 10px;
        }

        .logo img {
            max-width: 150px;
            margin-bottom: 20px;
        }

        h1 {
            font-size: 24px;
            margin-bottom: 10px;
            color: #333;
        }

        p {
            font-size: 14px;
            margin-bottom: 30px;
            color: #666;
        }

        input[type="text"],
        input[type="password"] {
            width: calc(100% - 20px);
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        input[type="submit"] {
            width: 100%;
            padding: 10px;
            border: none;
            background-color: #9055ff;
            color: white;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        input[type="submit"]:hover {
            background-color: #df98fa;
        }

        .credentials-table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        .credentials-table th,
        .credentials-table td {
            border: 1px solid #ccc;
            padding: 8px;
            font-size: 14px;
            text-align: left;
        }

        .credentials-table th {
            background-color: #f9f9f9;
        }

        a {
            color: #000000;
            text-decoration: none;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .wrapper {
                flex-direction: column;
                max-width: 100%;
                padding-right: 41px;
                height: auto;
                margin: 20px;
            }

            .left,
            .right {
                width: 100%;
                padding: 20px;
                text-align: center;
            }

            .contact-card img,
            .logo img {
                max-width: 100px;
                margin-bottom: 10px;
            }

            h1 {
                font-size: 20px;
            }

            p {
                font-size: 12px;
                margin-bottom: 20px;
            }

            img#login {
                margin: 2px 0 !important;
            }

            input[type="text"],
            input[type="password"] {
                width: calc(100% - 20px);
                padding: 10px;
                margin-bottom: 15px;
            }

            input[type="submit"] {
                padding: 10px;
                font-size: 14px;
            }

            .credentials-table th,
            .credentials-table td {
                font-size: 12px;
                padding: 6px;
            }

            a {
                font-size: 12px;
            }
        }

        .credentials-table tr {
            cursor: pointer;
        }

        .left .row {
            display: flex;
            justify-content: space-between;
            gap: 20px;
            /* Add this line to add space between columns */
            margin-bottom: 20px;
        }

        .left .column-box {
            width: 48%;
            padding: 10px;
            background-color: #f9f9f9;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.1);
        }

        .left .column-box h2 {
            font-size: 18px;
            color: #333;
            margin-bottom: 10px;
        }

        .left .column-box p {
            font-size: 14px;
            color: #666;
            margin: 5px 0;
        }

        .left .column-box p i {
            color: #9055ff;
            margin-right: 8px;
        }

        /* Existing CSS */

        .url-container {
            text-align: center;
            margin-top: 20px;
        }

        .url-container p {
            margin: 0;
        }

        .url-container a {
            color: #9055ff;
            text-decoration: none;
        }

        .url-container a:hover {
            text-decoration: underline;
        }

        .url-container .address {
            margin-top: 10px;
            font-size: 14px;
            color: #666;
            text-decoration: none;
            /* Ensures no underline on address text */
        }

        /* New CSS for Powered by Section */
        .powered-by {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: #666;
        }

        .powered-by a {
            color: #9055ff;
            text-decoration: none;
        }

        .powered-by a:hover {
            text-decoration: underline;
        }

        input:focus {
            border-color: #9055ff;
            outline: none;
        }

        .buyer-login-btn {
    position: absolute;
    top: 10px;
    right: 10px;
    background-color: #007bff; /* Blue */
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    font-weight: bold;
    border: none;
    border-radius: 5px;
    transition: background-color 0.3s ease, transform 0.2s;
    text-decoration: none;
    display: inline-block;
}

.buyer-login-btn:hover {
    background-color: #0056b3; /* Darker blue */
    transform: scale(1.05);
}

    </style>
</head>

<body>

    <div class="row">
        <div class="col-md-12">
            <a class="btn btn-info buyer-login-btn" href="<?php echo e(route('buyer.login')); ?>">Buyer Login</a>
        </div>
    </div>


    <div class="wrapper">
   
        <div class="right">
            <?php
            $company = \App\Models\Company::where('status', 'Active')->first();
        ?>
             <?php if(isset($company['logo'])): ?>
             <img id="login" style="display: block;margin-left: auto;margin-right: auto;" width="100px"
                 src="<?php echo e(asset('/backend/logo/' . ($company['logo'] ?? 0))); ?>" class="img-thumbnail "
                 alt="Responsive image">
         <?php else: ?>
             <h6 id="login" style="color: red">
                 ops! your logo missing
             </h6>
         <?php endif; ?>

            <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>
                <label for="email">Email</label>
                <input type="text" id="email" name="email" placeholder="Email">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" placeholder="Password"
                    autocomplete="current-password">


                <input type="submit" value="Sign in">
            </form>
            <?php if(env('APP_ENV') == 'local'): ?>
                <table class="credentials-table">
                    <tr data-email="info@xtreem.com" data-password="12345678">
                        <th>Email</th>
                        <th>Password</th>
                        <th>Role</th>
                    </tr>
                    <tr data-email="info@xtreem.com" data-password="12345678">
                        <td>info@xtreem.com</td>
                        <td>12345678</td>
                        <td>Admin</td>
                    </tr>
                </table>
            <?php endif; ?>
            
        </div>
    </div>


    <script>
        document.querySelectorAll('.credentials-table tr').forEach(row => {
            row.addEventListener('click', function() {
                const email = this.getAttribute('data-email');
                const password = this.getAttribute('data-password');

                // Fill the email and password fields
                document.getElementById('email').value = email;
                document.getElementById('password').value = password;
            });
        });
    </script>

</body>

</html>
<?php /**PATH F:\laragon\www\jubayer\resources\views/frontant/login.blade.php ENDPATH**/ ?>