

<?php $__env->startSection('title'); ?>
Report - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .bootstrap-switch-large {
        width: 200px;
    }

    @media  print {
        .no-print { display: none !important; }
        .print-area { margin: 0; padding: 0; }
        table { font-size: 12px; }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Report</h1>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="row">
    <div class="col-md-12">

        <?php if($errors->any()): ?>
        <div class="card">
            <div class="card-body">
                <div class="text-danger">
                    <h4><i class="fa fa-bell" style="color:red"></i> <?php echo e($errors->first()); ?></h4>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Filter Form -->
        <form action="<?php echo e(route('report.stock.stock')); ?>" method="POST" id="stocksub" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card card-outline card-info no-print">
                <div class="card-body">
                    <div class="row no-print">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Date Range:</label>
                                <input type="text" class="form-control" name="dateRange" id="reservation"
                                    value="<?php echo e(old('dateRange', $dateRange)); ?>" />
                                <?php $__errorArgs = ['dateRange'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Branch</label>
                              <select class="form-control select2" name="branch_id">



                                
   
   
      


                             <?php if(auth()->user()->role_id > 1): ?>
                              
                                    <?php $__currentLoopData = $branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?>" <?php echo e(auth()->user()->branch_id == $value->id ? 'selected' :''); ?>><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?> 

                                   <?php $__currentLoopData = $branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->id); ?> <?php echo e($branch_id == $value->id ? 'selected' : ''); ?>"><?php echo e($value->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
  
                                    </select>

                                <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Accessories</label>
                                <select class="select2 form-control" name="product_id" data-placeholder="Search Accessories">
    <option value="all" <?php echo e($product_id == 'all' ? 'selected' : ''); ?>>All Accessories</option>
    <?php $__currentLoopData = $accressorise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eachInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($eachInfo->id); ?>" 
            <?php echo e($product_id == $eachInfo->id ? 'selected' : ''); ?>>
            <?php echo e($eachInfo->name); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>

                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Unit</label>
              <select class="select2 form-control" name="unit" data-placeholder="Search Units">
    <option value="all" <?php echo e($unit == 'all' ? 'selected' : ''); ?>>All Units</option>
    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($u); ?>" <?php echo e($unit == $u ? 'selected' : ''); ?>><?php echo e($u); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>


                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <button type="submit" class="btn btn-sm btn-success">
                                    <i class="fa fa-search"></i> Search
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <?php if($StockDetails->isNotEmpty()): ?>
    <div class="col-md-12">
        <div class="card card-default print-area">
            <div class="card-header no-print">
                <h3 class="card-title">Stock In Detail</h3>
                <a onclick="window.print()" class="btn btn-default float-right my-2 no-print">
                    <i class="fas fa-print"></i> Print
                </a>
            </div>

            <div class="card-body">
                <div class="invoice p-3 mb-3">
                    <div class="row">
                        <div class="col-12 table-responsive">
                            <table class="table table-bordered">
                                <tr>
                                    <td style="text-align:center">
                                        <?php if($companyInfo && $companyInfo->logo): ?>
                                            <a href="<?php echo e(route('home')); ?>">
                                                <img width="200px" src="<?php echo e(asset('/backend/logo/' . $companyInfo->logo)); ?>" alt="">
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td width="70%" style="text-align:center">
                                        <h3>Stock In Detail</h3>
                                        <h4>
                                            <b>From Date: <?php echo e($from_date); ?></b>, 
                                            <b>To Date: <?php echo e($to_date); ?></b>
                                        </h4>
                                    </td>
                                </tr>
                            </table>

                            <table id="datatablexcel" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Date</th>
                                        <th>Product</th>
                                         <th>Unit</th>
                                        <th class="text-right">Quantity</th>
                                        <th class="text-right">KG</th>
                                        <th class="text-right">Avg Unit Price</th>
                                        <th class="text-right">Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $StockDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e($item->created_at->format('Y-m-d')); ?></td>

                                            <td><?php echo e($item->accessories->name); ?></td>
                                             <td><?php echo e($item->accessories->unit); ?></td>
                                            <td class="text-right"><?php echo e($item->in_quantity); ?></td>
                                            <td class="text-right"><?php echo e($item->kg); ?></td>
                                             <td class="text-right"><?php echo e($item->price); ?></td>
                                            <td class="text-right"><?php echo e($item->total_price); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center text-danger">NO DATA RECORDS</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="4" class="text-right">Total</th>
                                        <th class="text-right"><?php echo e($totals['qty']); ?></th>
                                          <th class="text-right"><?php echo e($totals['kg']); ?></th>
                                        <th class="text-right"><?php echo e($totals['unitprc']); ?></th>
                                        <th class="text-right"><?php echo e($totals['totalprc']); ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="col-md-4">
                            <p>Prepared By:_____________<br/>Date:____________________</p>
                        </div>
                        <div class="col-md-6 text-center"></div>
                        <div class="col-md-2">
                            <p>Approved By:________________<br/>Date:_________________</p>
                        </div>

                        <div class="col-md-12 bg-success text-center mt-3">
                            Thank you for choosing <?php echo e($companyInfo->company_name ?? 'N/A'); ?> products.
                            We believe you will be satisfied by our services.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php echo $__env->make('backend.pages.reports.excel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
$(document).ready(function () {
    $('#stocksub').on('submit', function () {
        var product_id = $(".proName").find('option:selected').val();
        if(product_id){
            $(this).append('<input type="hidden" name="product_id" value="' + product_id + '" />');
        }
    });
});


$('#reservation').daterangepicker({
    autoUpdateInput: false,
    locale: { cancelLabel: 'Clear' }
});

<?php if(!empty($dateRange)): ?>
    $('#reservation').val("<?php echo e($dateRange); ?>");
<?php endif; ?>

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/reports/stock.blade.php ENDPATH**/ ?>