

<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('settings.branch.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('settings.account.index')); ?>">Account List</a>
                            </li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Edit Account</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Account List</h3>
                    <div class="card-tools">
                        <?php if(helper::roleAccess('settings.branch.create')): ?>
                            <a class="btn btn-default" href="<?php echo e(route('settings.account.create')); ?>"><i
                                    class="fas fa-plus"></i>
                                Add New</a>
                        <?php endif; ?>
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">

                    <form class="needs-validation" method="POST"
                        action="<?php echo e(route('settings.account.update', $editInfo->id)); ?>" novalidate>
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="col-md-6 mb-3">
                                <label for=""> Account List <span class="text-danger">*</span></label>
                                <select name="parent_id" class="custom-select select2" id="parent_id">
                                    <option selected disabled>--select Account--</option>
                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option  <?php echo e($editInfo->parent_id == $account->id ? "selected":""); ?>

                                            value="<?php echo e($account->id); ?>">
                                            <?php echo e($account->account_name); ?> <?php echo e($account->parent->account_name ?? ''); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Account Name * :</label>
                                <input type="text" name="account_name" class="form-control" id="validationCustom01"
                                    placeholder="Account Name" value="<?php echo e($editInfo->account_name); ?>">
                                <?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02"> Account Number :</label>
                                <input type="text" name="account_code" class="form-control" id="validationCustom02"
                                    placeholder="Account Number" value="<?php echo e($editInfo->accountCode); ?>" required>
                                <?php $__errorArgs = ['account_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02">Bank Name (if need) :</label>
                                <input type="text" name="bank_name" class="form-control" id="validationCustom02"
                                    placeholder="Bank Name" value="<?php echo e($editInfo->bank_name); ?>" required>
                            </div>
                             <?php if($editInfo->depreciation != 0): ?>
                             <div class="col-md-6 mb-3" id="depreciation">
                                 <label for="validationCustom02"> Depreciation (%) :</label>
                                 <input type="number" value="<?php echo e($editInfo->depreciation); ?>" name="depreciation" class="form-control" id="validationCustom02"
                                     placeholder=""  >
                             </div>
                             <?php endif; ?>
                        </div>

                        <div class="form-row">
                            <div class="card" style="width: 18rem;">
                                <div class="card-body">
                                    <div class="form-check">
                                        <input class="form-check-input" <?php echo e($editInfo->bill_by_bill == 1 ? "checked":""); ?> type="checkbox" value="1" name="billbybillpayment" id="flexCheckDefault">
                                        <label class="form-check-label" for="flexCheckDefault">
                                          Bill By Bill Payment
                                        </label>
                                    </div>
                                </div>
                              </div>
                        </div>

                        <button class="btn btn-info" type="submit"><i class="fa fa-save"></i>&nbsp;Update</button>
                    </form>


                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/settings/account/edit.blade.php ENDPATH**/ ?>