<?php $__env->startSection('title'); ?>
    Report - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Cash Book
                        Report </h1>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12 no-print">
            <div class="card card-default">
                <div class="card-body">
                    <form action="<?php echo e(route('report.cashbook.cashbook')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="account_id">Account</label>
                                    <select name="account_id" id="account_id" class="form-control select2">
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.account','data' => ['setAccounts' => $accounts,'skip' => [getAccountByUniqueID(8)->id]]]); ?>
<?php $component->withName('account'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['setAccounts' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($accounts),'skip' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([getAccountByUniqueID(8)->id])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">Start Date</label>
                                    <input type="date" name="start_date" id="start_date" class="form-control"
                                        value="<?php echo e(request('start_date') ?? date('Y-m-d')); ?>">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">End Date</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control"
                                        value="<?php echo e(request('end_date') ?? date('Y-m-d')); ?>">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="mt-4 btn btn-primary">Search</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <?php if(isset($ledgerEntries) && !empty($ledgerEntries)): ?>
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header no-print">
                        <h3 class="card-title">Cash Book Report</h3>
                        <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2 no-print"><i
                                class="fas fa-print"></i>
                            Print</a>
                        <div id="tableActions" class=" float-right my-2 no-print"></div>
                    </div>

                    <div class="card-body">

                        <div class="invoice p-3 mb-3">
                            <div class="row">
                                <div class="col-12 table-responsive">
                                    <table class="table  table-bordered">
                                        <tr>
                                            <td style="text-align: center">
                                                <?php if(isset($companyInfo->logo)): ?>
                                                    <a href="<?php echo e(route('home')); ?>">
                                                        <img width="200px"
                                                            src="<?php echo e(asset('/backend/logo/' . $companyInfo->logo)); ?>"
                                                            style="" alt="">
                                                    </a>
                                                <?php endif; ?>
                                            </td>
                                            <td width="70%" style="text-align: center">
                                                <h3>Cash Book</h3>
                                                <h4><b>From Date: <?php echo e($startDate); ?></b>, <b>To date:
                                                    <?php echo e($endDate); ?> </b></h4>
                                            </td>
                                        </tr>
                                    </table>

                                    <table class="table table-bordered mt-2">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Voucher No</th>
                                                <th>Account Name</th>
                                                <th>Description</th>
                                                <th>Debit</th>
                                                <th>Credit</th>
                                                <th>Balance</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="6"><strong>Opening Balance</strong></td>
                                                <td><?php echo e(number_format($openingBalance, 2)); ?></td>
                                            </tr>
                                            <?php $__currentLoopData = $ledgerEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($entry['date']->format('Y-m-d')); ?></td>
                                                    <td><?php echo e($entry['invoice']); ?></td>
                                                    <td><?php echo e($entry['account_name']); ?></td>
                                                    <td><?php echo e($entry['description']); ?></td>
                                                    <td><?php echo e(number_format($entry['debit'], 2)); ?></td>
                                                    <td><?php echo e(number_format($entry['credit'], 2)); ?></td>
                                                    <td><?php echo e(number_format($entry['balance'], 2)); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td colspan="4"><strong>Closing Balance</strong></td>
                                                <td><?php echo e(number_format(collect($ledgerEntries)->sum("debit"))); ?></td>
                                                <td><?php echo e(number_format(collect($ledgerEntries)->sum("credit"))); ?></td>
                                                <td><?php echo e(number_format($runningBalance, 2)); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="col-md-4  float-left">
                                    <br>
                                    <br>

                                    <p>Prepared By:_____________<br />
                                        Date:____________________
                                    </p>
                                </div>
                                <div class="col-md-6 text-center">
                                </div>
                                <div class="col-md-2  ">
                                    <br>
                                    <br>
                                    <p>Approved By:________________<br />
                                        Date:_________________</p>
                                </div>

                                <hr>


                                <div class="col-md-12 bg-success" style="text-align: center">
                                    Thank you for choosing <?php echo e($companyInfo->company_name ?? 'N/A'); ?> products.
                                    We believe you will be satisfied by our services.
                                </div>
                                <!-- /.col -->



                            </div>
                            <!-- Table row -->

                        </div>

                    </div>
                </div>
            </div>

        <?php endif; ?>




    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('backend.pages.reports.excel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/reports/cashbook.blade.php ENDPATH**/ ?>