<script type="text/javascript">
let table = $('#systemDatatable').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
        "url": "<?php echo e(route('settings.commissionRules.dataProcessing')); ?>",
        "dataType": "json",
        "type": "GET",
        "data": {
            "_token": "<?= csrf_token() ?>"
        }
    },
    "columns": [{
            "data": "id",
            "orderable": true
        },
        {
            "data": "employee",
            "orderable": true
        },
        {
            "data": "commission_type",
            "orderable": true
        },
        {
            "data": "fixed_percentage",
            "orderable": true

        },
        {
            "data": "min_amount",
            "orderable": true
        },
        {
            "data": "max_amount",
            "orderable": false,

        },
        {
            "data": "percentage",
            "orderable": false,
            "class": 'text-nowrap',
        },
        {
            "data": "action",
            "class": 'text-nowrap',
            "searchable": false,
            "orderable": false
        },
    ],

    "fnDrawCallback": function() {
        $("[name='my-checkbox']").bootstrapSwitch({
            size: "small",
            onColor: "success",
            offColor: "danger"
        });
    },

});


var buttons = new $.fn.dataTable.Buttons(table, {
    buttons: [
        'copyHtml5',
        'excelHtml5',
        'csvHtml5',
        'pdfHtml5',
        'print',
    ]
}).container().appendTo($('#buttons'));
</script><?php /**PATH E:\jubayer\resources\views/backend/pages/settings/commission_rules/script.blade.php ENDPATH**/ ?>