<script type="text/javascript">
    let table = $('#systemDatatable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo e(route('inventorySetup.customer.dataProcessingCustomerDashboard')); ?>",
            "dataType": "json",
            "type": "GET",
            "data": {
                "_token": "<?= csrf_token() ?>"
            }
        },
        "columns": [{
                "data": "id",
                "orderable": true
            },
            {
                "data": "name",
                "orderable": true
            },
           

            {
                "data": "phone",
                "orderable": true
            },
            {
                "data": "address",
                "orderable": true
            },
            {
                "data": "totalSale",
                "orderable": true
            },
            {
                "data": "totalDue",
                "orderable": true
            },
           
            {
                "data": "action",
                "class": 'text-nowrap',
                "searchable": false,
                "orderable": false
            },
        ],

        "fnDrawCallback": function() {
            $("[name='my-checkbox']").bootstrapSwitch({
                size: "small",
                onColor: "success",
                offColor: "danger"
            });
        },

    });


    var buttons = new $.fn.dataTable.Buttons(table, {
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print',
        ]
    }).container().appendTo($('#buttons'));
</script>
<?php /**PATH E:\jubayer\resources\views/backend/pages/inventories/customer/customerScript.blade.php ENDPATH**/ ?>