@php
  use App\Helpers\Helper;
  $company = \App\Models\Company::where('status', 'Active')->first();
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta name="csrf-token" content="{{ csrf_token() }}" />
  <title>{{ __('Buyer\'s Panel |') }} @yield('title')</title>
  @if (isset($company->favicon))
    <link rel="shortcut icon" href="{{ asset('/backend/favicon/' . $company->favicon) }}" type="image/x-icon">
  @endif
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback" />
  <link rel="stylesheet" href="{{ asset('backend/assets/plugins/fontawesome-free/css/all.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('backend/assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}" />
  <link rel="stylesheet" href="{{ asset('backend/assets/dist/css/adminlte.min.css') }}" />
  <style>
    body {
      background: linear-gradient(to bottom right, #01680f, #03880e, #0d6402) !important;
    }
  </style>
  @yield('styles')
</head>

<body class="hold-transition login-page" style="background: lightgray;">
  <div class="login-box">
    <div class="login-logo"></div><!-- /.login-logo -->
    <div class="card card-outline card-primary">
      <div class="card-body login-card-body">
        @if (isset($company['logo']))
          <img style="display: block;margin-left: auto;margin-right: auto;" src="{{ asset('/backend/logo/' . ($company['logo'] ?? 0)) }}" class="img-thumbnail " alt="Responsive image" />
        @else
          <h6 style="color: red">{{ __('ops! your logo missing') }}</h6>
        @endif
        @yield('note')
        @yield('content')
      </div><!-- /.login-card-body -->
    </div>
  </div><!-- /.login-box -->
  <script src="{{ asset('backend/assets/plugins/jquery/jquery.min.js') }}"></script>
  <script src="{{ asset('backend/assets/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/assets/dist/js/adminlte.min.js') }}"></script>
  @yield('scripts')
</body>
</html>
