@php
    $num = isset($countNum) ? $countNum + 1 : 0;
    $selected = isset($selectVal) ? $selectVal : 0;
    $skip = $skip ?? [];
@endphp

@foreach ($setAccounts->sortBy(fn($a) => strtolower($a->account_name)) as $account)

    @if (in_array($account->id, $skip))
    @else
        @if ($account->subAccount->isNotEmpty())
            <x-account :setAccounts="$account->subAccount" :skip="$skip" :selectVal="$selected" :countNum="$num" />
        @else
           @php 

           $user = auth()->user();
           if($user->role_id > 1){
          $accountInfo = App\Models\ChartOfAccount::where('id',$account->id)->where('branch_id', $user->branch_id)->first();
           }else{
              $accountInfo = App\Models\ChartOfAccount::where('id',$account->id)->first();
           }
              
             
           @endphp
           @if($accountInfo)
            <option {{ $selected == $account->id ? 'selected' : '' }} value="{{ $account->id }}">
                {{ $account->account_name }} {{ $account->account_code }}  {{ $account->bank_name }}
                @if ($account->accountable_type && $account->accountable_id)
                {{ optional($account->accountable)->phone ?? 'N/A' }}
                @endif
            </option>
            @endif
        @endif
    @endif
@endforeach
