@extends('backend.layouts.master')
@section('title')
    Settings - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }
        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 34px;
        }
        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }
        input:checked + .slider {
            background-color: #2196F3;
        }
        input:checked + .slider:before {
            transform: translateX(26px);
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">User Manage</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('usermanage.user.index'))
                            <li class="breadcrumb-item"><a href="{{ route('usermanage.user.index') }}">User</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span id="page-title">User List</span></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title" id="card-title">User List</h3>
                    <div class="card-tools">
                        <div class="btn-group mr-2">
                            <label class="toggle-switch">
                                <input type="checkbox" id="showDeletedToggle">
                                <span class="slider"></span>
                            </label>
                            <span class="ml-2" id="toggle-label">Show Active Users</span>
                        </div>
                        
                        <a class="btn btn-default" href="{{ route('usermanage.user.create') }}">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Name</th>
                                    <th>Branch</th>
                                    <th>Role</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                               
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($users as $data)
                                <tr>
                                    <td>
                                        {{$loop->index + 1}}

                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>SL</th>
                                    <th>Name</th>
                                    <th>Branch</th>
                                    <th>Role</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="card-footer"></div>
            </div>
        </div>
    </div>
@endsection

<script>
$(document).ready(function() {
    let showDeleted = false;
    
 

    // Add export buttons
    table.buttons().container().appendTo('#buttons');

    // Toggle between active and deleted users
    $('#showDeletedToggle').change(function() {
        showDeleted = $(this).is(':checked');
        
        if (showDeleted) {
            $('#toggle-label').text('Show Deleted Users');
            $('#card-title').text('Deleted Users');
            $('#page-title').text('Deleted Users');
        } else {
            $('#toggle-label').text('Show Active Users');
            $('#card-title').text('User List');
            $('#page-title').text('User List');
        }
        
        table.ajax.reload();
    });

    // Status toggle handler
    $(document).on('switchChange.bootstrapSwitch', '.status_row', function(event, state) {
        let statusRoute = $(this).attr('status_route');
        
        $.ajax({
            url: statusRoute,
            type: 'GET',
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message || 'Status updated successfully');
                    table.ajax.reload(null, false);
                } else {
                    toastr.error(response.message || 'Failed to update status');
                    // Revert the switch
                    $(event.target).bootstrapSwitch('toggleState', true);
                }
            },
            error: function(xhr) {
                toastr.error('Something went wrong');
                // Revert the switch
                $(event.target).bootstrapSwitch('toggleState', true);
            }
        });
    });

    // Soft Delete User
    $(document).on('click', '.delete-btn', function() {
        let userId = $(this).data('id');
        let deleteRoute = "{{ url('admin/usermanage/user') }}/" + userId;
        
        Swal.fire({
            title: 'Are you sure?',
            text: "This user will be moved to trash. You can restore it later.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: deleteRoute,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Deleted!', response.message, 'success');
                            table.ajax.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        let message = 'Something went wrong.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }
                        Swal.fire('Error!', message, 'error');
                    }
                });
            }
        });
    });

    // Restore User
    $(document).on('click', '.restore-btn', function() {
        let userId = $(this).data('id');
        let restoreRoute = "{{ url('admin/usermanage/user/restore') }}/" + userId;
        
        Swal.fire({
            title: 'Restore User?',
            text: "This user will be restored and made active again.",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, restore it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: restoreRoute,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Restored!', response.message, 'success');
                            table.ajax.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        let message = 'Something went wrong.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }
                        Swal.fire('Error!', message, 'error');
                    }
                });
            }
        });
    });

    // Force Delete User (Permanent)
    $(document).on('click', '.force-delete-btn', function() {
        let userId = $(this).data('id');
        let forceDeleteRoute = "{{ url('admin/usermanage/user/force-delete') }}/" + userId;
        
        Swal.fire({
            title: 'Permanently Delete?',
            text: "This action cannot be undone! The user will be permanently deleted from the database.",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete permanently!',
            input: 'text',
            inputPlaceholder: 'Type "DELETE" to confirm',
            preConfirm: (inputValue) => {
                if (inputValue !== 'DELETE') {
                    Swal.showValidationMessage('You need to type "DELETE" to confirm!');
                    return false;
                }
                return true;
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: forceDeleteRoute,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Permanently Deleted!', response.message, 'success');
                            table.ajax.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        let message = 'Something went wrong.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }
                        Swal.fire('Error!', message, 'error');
                    }
                });
            }
        });
    });

    // Legacy delete handler (if you still have old delete links)
    $(document).on('click', '.delete_row', function() {
        let userId = $(this).attr('delete_id');
        let deleteRoute = $(this).attr('delete_route');
        
        Swal.fire({
            title: 'Are you sure?',
            text: "This user will be moved to trash. You can restore it later.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: deleteRoute,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Deleted!', response.message, 'success');
                            table.ajax.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    }
                });
            }
        });
    });
});
</script>

@section('scripts')
    @include('backend.pages.usermanage.users.script')
@endsection