@extends('backend.layouts.master')

@section('title', 'Show Stock Out')

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Show Stock Out</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('stockin.list') }}">Stock In</a></li>
                    <li class="breadcrumb-item active">Show</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row justify-content-center">
    <div class="col-md-11">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Stock Out Details</h3>
            </div>

            <div class="card-body">

          <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="stock-out-table">
                            <thead class="bg-light">
                                <tr>
                                 
                                   <th width="20%">Accessory Name</th>
                                        <th width="8%">Unit</th>
                                  
                                        <th width="12%">Out Kg</th>
                                        <th width="12%">Out Quantity</th>
                                        <th width="23%">Description</th>
                                      


                                </tr>
                            </thead>
                            <tbody id="additional-fields-container">
                                 @foreach ($stockIn->stock_in_details as $details)
                                    <tr class="dynamic-row" id="row-{{ $details->id }}">
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="{{ $details->accessories->name ?? '' }}" readonly>
                                            <input type="hidden" name="accessory_id[]" value="{{ $details->aceesories_id }}">
                                            <input type="hidden" name="detail_id[]" value="{{ $details->id }}">
                                            <input type="hidden" name="old_quantity[]" value="{{ $details->in_quantity }}">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="{{ $details->accessories->unit ?? '' }}" readonly>
                                        </td>
                                        
                                        <td>
                                            <input type="number" name="in_quantity[]" 
                                                class="form-control form-control-sm quantity-input"
                                                value="{{ $details->in_quantity }}" placeholder="Enter quantity" required>
                                        </td>
                                        {{-- <td>
                                            <input type="number" name="price[]" 
                                                class="form-control form-control-sm price-input" 
                                                value="{{ number_format($details->price, 2) }}" 
                                                step="0.01" placeholder="Enter price">
                                        </td> --}}
                                        <td>
                                            <input type="number" name="kg[]" class="form-control form-control-sm" 
                                                value="{{ $details->kg }}" placeholder="Enter kg">
                                        </td>
                                        <td>
                                            <textarea name="description[]" class="form-control form-control-sm" 
                                                rows="2" placeholder="Enter description">{{ $details->description }}</textarea>
                                        </td>
                                       
                                      
                                    </tr>
                                    @endforeach
                            
                            </tbody>
                          
                        </table>
                    </div>
              

            </div>

            <div class="card-footer">
                <a href="{{ route('stockOut.list') }}" class="btn btn-secondary">Back to List</a>
            </div>
        </div>
    </div>
</div>

@endsection
