@extends('backend.layouts.master')

@section('title', 'Edit Stock Out')

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Edit Stock Out</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('stockOut.list') }}">Stock Out</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row justify-content-center">
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Edit Stock Out</h3>
            </div>

            <form action="{{ route('stockOut.update', $stockOut->id) }}" method="POST" id="edit-stockin-form">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <!-- Accessory Selection Section -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="accessory_name">Accessory Name</label>
                                <select name="accessory_name" id="accessory_name"
                                    class="form-control @error('accessory_name') is-invalid @enderror">
                                    <option value="">Select Accessory</option>
                                    @if(auth()->user()->role_id > 1)
                                        @foreach (App\Models\Accesories::where('branch_id', auth()->user()->branch_id)->get() as $accessory)
                                            @php
                                                $stock = \App\Models\stockinsummary::where('product_id', $accessory->id)->sum('quantity');
                                                $stockKg = \App\Models\stockinsummary::where(
                                                        'product_id',
                                                        $accessory->id,
                                                    )->sum('kg');
                                            @endphp
                                            <option value="{{ $accessory->name }}" data-id="{{ $accessory->id }}"
                                                data-unit="{{ $accessory->unit }}" data-stock="{{ $stock }}"  
                                                {{ $stockOut->accessory_id == $accessory->id ? 'selected' : '' }}>
                                                {{ $accessory->name }} (Stock: Qty:{{ $stock }}, Kg:{{$stockKg}})
                                            </option>
                                        @endforeach
                                    @else 
                                        @foreach (App\Models\Accesories::all() as $accessory)
                                            @php
                                                $stock = \App\Models\stockinsummary::where('product_id', $accessory->id)->sum('quantity');
                                                  $stockKg = \App\Models\stockinsummary::where(
                                                        'product_id',
                                                        $accessory->id,
                                                    )->sum('kg');
                                            @endphp
                                            <option value="{{ $accessory->name }}" data-id="{{ $accessory->id }}"
                                                data-unit="{{ $accessory->unit }}" data-stock="{{ $stock }}"  
                                                {{ $stockOut->accessory_id == $accessory->id ? 'selected' : '' }}>
                                                {{ $accessory->name }} (Stock: Qty:{{ $stock }}, Kg:{{$stockKg}})
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                                @error('accessory_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-3" style="display: none">
                            <div class="form-group">
                                <label for="unit">Unit</label>
                                <input type="text" name="unit" id="unit"
                                    class="form-control @error('unit') is-invalid @enderror"
                                    value="{{ $stockOut->accessory->unit ?? old('unit') }}" 
                                    placeholder="Unit will be auto-filled" readonly required>
                                @error('unit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button type="button" id="append-fields" class="btn btn-success btn-sm w-100 mb-3">
                                <i class="fa fa-plus"></i> Add
                            </button>
                        </div>
                    </div>

                    <!-- Stock Out Details Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="stock-out-table">
                            <thead class="bg-light">
                                <tr>
                                    {{-- <th width="15%">Accessory</th>
                                    <th width="8%">Unit</th>
                                    <th width="20%">Description</th>
                                    <th width="10%">Quantity</th>
                                 
                                    <th width="8%">KG</th>
                                   
                                    <th width="8%">Action</th> --}}
                                   <th width="20%">Accessory Name</th>
                                        <th width="8%">Unit</th>
                                  
                                        <th width="12%">Out Kg</th>
                                        <th width="12%">Out Quantity</th>
                                        <th width="23%">Description</th>
                                        <th width="10%">Action</th>


                                </tr>
                            </thead>
                            <tbody id="additional-fields-container">
                                @if ($stockOut)
                                    @foreach ($stockOut->stock_in_details as $details)
                                    <tr class="dynamic-row" id="row-{{ $details->id }}">
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="{{ $details->accessories->name ?? '' }}" readonly>
                                            <input type="hidden" name="accessory_id[]" value="{{ $details->aceesories_id }}">
                                            <input type="hidden" name="detail_id[]" value="{{ $details->id }}">
                                            <input type="hidden" name="old_quantity[]" value="{{ $details->in_quantity }}">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="{{ $details->accessories->unit ?? '' }}" readonly>
                                        </td>
                                        
                                        <td>
                                            <input type="number" name="in_quantity[]" 
                                                class="form-control form-control-sm quantity-input"
                                                value="{{ $details->in_quantity }}" placeholder="Enter quantity" required>
                                        </td>
                                        {{-- <td>
                                            <input type="number" name="price[]" 
                                                class="form-control form-control-sm price-input" 
                                                value="{{ number_format($details->price, 2) }}" 
                                                step="0.01" placeholder="Enter price">
                                        </td> --}}
                                        <td>
                                            <input type="number" name="kg[]" class="form-control form-control-sm" 
                                                value="{{ $details->kg }}" placeholder="Enter kg">
                                        </td>
                                        <td>
                                            <textarea name="description[]" class="form-control form-control-sm" 
                                                rows="2" placeholder="Enter description">{{ $details->description }}</textarea>
                                        </td>
                                        {{-- <td>
                                            <input type="number" name="total_price[]" 
                                                class="form-control form-control-sm total-price-input" 
                                                value="{{ $details->total_price }}" readonly>
                                        </td> --}}
                                        <td class="text-center">
                                            <button type="button" class="btn btn-danger btn-sm remove-row" 
                                                data-row-id="row-{{ $details->id }}">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                @endif
                            </tbody>
                            {{-- <tfoot>
                                <tr class="bg-light">
                                    <th colspan="6" class="text-right">Grand Total:</th>
                                    <th>
                                        <input type="number" id="grand-total" class="form-control form-control-sm font-weight-bold" 
                                            value="0.00" readonly>
                                    </th>
                                    <th></th>
                                </tr>
                            </tfoot> --}}
                        </table>
                    </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Update Stock Out
                    </button>
                    <a href="{{ route('stockOut.list') }}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i> Back to List
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        // Calculate grand total
        function calculateGrandTotal() {
            let grandTotal = 0;
            $('.total-price-input').each(function() {
                let value = parseFloat($(this).val()) || 0;
                grandTotal += value;
            });
            $('#grand-total').val(grandTotal.toFixed(2));
        }

        // Initial grand total calculation
        calculateGrandTotal();

        // Event listener for the accessory name change
        $('#accessory_name').on('change', function () {
            var accessoryName = $(this).val();
            var accessoryId = $(this).find(':selected').data('id');
            var unit = $(this).find(':selected').data('unit');
            if (accessoryName) {
                $('#unit').val(unit);
            } else {
                $('#unit').val('');
            }
        });

        // Auto-calculate total price on quantity or price input
        $(document).on('input', '.price-input, .quantity-input', function () {
            var $row = $(this).closest('tr');
            var price = parseFloat($row.find('.price-input').val()) || 0;
            var quantity = parseFloat($row.find('.quantity-input').val()) || 0;
            var total = price * quantity;
            $row.find('.total-price-input').val(total.toFixed(2));
            calculateGrandTotal();
        });

        // Handle append button click to add new rows
        let rowCount = {{ $stockOut->stock_in_details->count() ?? 0 }};
        $('#append-fields').on('click', function () {
            var accessoryName = $('#accessory_name').val();
            var accessoryId = $('#accessory_name').find(':selected').data('id');
            var unit = $('#unit').val();
            
            if (accessoryName && unit) {
                rowCount++;
                var newRow = `
                    <tr class="dynamic-row" id="row-${rowCount}">
                        <td>
                            <input type="text" class="form-control form-control-sm" value="${accessoryName}" readonly>
                            <input type="hidden" name="accessory_id[]" value="${accessoryId}">
                            <input type="hidden" name="detail_id[]" value="0">
                            <input type="hidden" name="old_quantity[]" value="0">
                        </td>
                        <td>
                            <input type="text" class="form-control form-control-sm" value="${unit}" readonly>
                        </td>
                       
                        <td>
                            <input type="number" name="in_quantity[]" 
                                class="form-control form-control-sm quantity-input" 
                                placeholder="Enter quantity" required>
                        </td>
                      
                        <td>
                            <input type="number" name="kg[]" class="form-control form-control-sm" 
                                placeholder="Enter kg">
                        </td>
                        <td>
                            <textarea name="description[]" class="form-control form-control-sm" rows="2" 
                                placeholder="Enter description" required></textarea>
                        </td>
                        <td class="text-center">
                            <button type="button" class="btn btn-danger btn-sm remove-row" 
                                data-row-id="row-${rowCount}">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
                $('#additional-fields-container').append(newRow);
            } else {
                alert('Please select an accessory and unit before adding new items.');
            }
        });

        // Handle row removal
        $(document).on('click', '.remove-row', function () {
            var rowId = $(this).data('row-id');
            $('#' + rowId).remove();
            calculateGrandTotal();
        });

        // Form submission with price formatting
        $('#edit-stockin-form').submit(function () {
            $('.price-input').each(function () {
                var price = parseFloat($(this).val());
                if (!isNaN(price)) {
                    $(this).val(price.toFixed(2));
                }
            });
        });
    });
</script>

@push('styles')
<style>
    .table th {
        vertical-align: middle;
        font-size: 0.875rem;
    }
    
    .table td {
        vertical-align: middle;
        padding: 0.5rem;
    }
    
    .form-control-sm {
        font-size: 0.875rem;
    }
    
    .total-price-input {
        background-color: #f8f9fa;
        font-weight: bold;
    }
    
    #grand-total {
        background-color: #e9ecef;
        font-weight: bold;
        color: #495057;
    }
    
    .dynamic-row:hover {
        background-color: #f8f9fa;
    }
</style>
@endpush

@push('scripts')
@endpush