@extends('backend.layouts.master')

@section('title')
    Account - {{ $title }}
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('settings.credit.voucher.index'))
                            <li class="breadcrumb-item"><a href="{{ route('settings.credit.voucher.index') }}">Receive
                                    Voucher
                                    List</a>
                            </li>
                        @endif
                        <li class="breadcrumb-item active"><span>Edit Receive Voucher</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Receive Voucher List</h3>
                    <div class="card-tools">
                        @if (helper::roleAccess('settings.credit.voucher.create'))
                            <a class="btn btn-default" href="{{ route('settings.credit.voucher.create') }}"><i
                                    class="fas fa-plus"></i>
                                Add New</a>
                        @endif
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <form class="needs-validation" id="getform" method="POST"
                    action="{{ route('settings.credit.voucher.update', $editInfo->id) }}">
                    @csrf
                    <div class="card-body">
                        <div class="form-row">
                            <div class="col-md-4 mb-3">
                                <label>Invoice Number :</label>
                                <input class="bg-green form-control" readonly=""
                                    style="padding: 5px; font-weight : bold; width: 100%"
                                    value="{{ $editInfo->voucher_no }} ">
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="validationCustom01">Cost Center *:</label>
                                <select class="form-control select2" disabled id="cost_center">
                                    <option value="0">No Cost Center</option>
                                    <option {{ $editInfo->project_id ? 'selected' : '' }} value="project">Project</option>
                                    <option {{ $editInfo->branch_id ? 'selected' : '' }} value="branch">Branch</option>
                                </select>
                                <span class="error text-red text-bold"></span>
                            </div>

                            <div class="col-md-4 mb-3" id="project_div" style="display: none;">
                                <label for="validationCustom01">Project *:</label>
                                <select class="form-control select2" id="project_id" name="project_id">
                                    <option value="0">--Select--</option>
                                    @foreach ($projects as $item)
                                        <option value="{{ $item->id }}"
                                            {{ $editInfo->project_id == $item->id ? 'selected' : '' }}>
                                            {{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <span class="error text-red text-bold"></span>
                            </div>
                            <div class="col-md-4 mb-3" id="branch_div" style="display: none;">
                                <label for="validationCustom01">Branch *:</label>
                                <select class="form-control select2" id="branch_id" name="branch_id">
                                    <option value="0">--Select--</option>
                                    <!-- Add branch options here -->
                                    @foreach ($branchs as $branch)
                                        <option value="{{ $branch->id }}"
                                            {{ $editInfo->branch_id == $branch->id ? 'selected' : '' }}>
                                            {{ $branch->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <span class="error text-red text-bold"></span>
                            </div>


                            <div class="col-md-4 mb-3">
                                <label>Date:</label>
                                <div class="input-group date" id="reservationdate" data-target-input="nearest">
                                    <input type="text" id="date" name="date" data-toggle="datetimepicker"
                                        value="{{ date('Y-m-d') ?? $editInfo->date }}"
                                        class="form-control datetimepicker-input" data-target="#reservationdate" />
                                    <div class="input-group-append" data-target="#reservationdate"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <span class=" error text-red text-bold"></span>
                            </div>

                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">

                        <table class="table table-bordered table-hover" id="show_item">
                            <thead>
                                <tr>
                                    <th colspan="8">Receive Voucher</th>
                                </tr>
                                <tr>
                                    <td width="50%"><strong>Account Name </strong></td>
                                    <td width="10%"><strong>Invoice</strong></td>
                                    <td width="15%"><strong>Credit</strong></td>
                                    <td width="15%"><strong>Debit</strong></td>
                                    <td width="10%"><strong>Action</strong></td>
                                </tr>
                            </thead>
                            <tbody id="main-table">
                                <tr>
                                    <td>
                                        <div style="display: flex; align-items: center;">
                                            <select style="width: 90%;" class="form-control select2" id="account_id">
                                                <x-account :setAccounts="$accounts" />
                                            </select>
                                            <span class=" error text-red text-bold"></span>
                                            <select name="type" style="width: 10%; margin-left: 5px;">
                                                <option value="CR">CR</option>
                                                <option value="DR">DR</option>
                                            </select>
                                        </div>
                                    </td>
                                    <td id="payment-options-container">
                                        <!-- Payment options will be inserted here if the account is bill-by-bill -->
                                    </td>
                                    <td>
                                        <input type="text" id="credit" class="form-control" placeholder="credit">
                                        <span class=" error text-red text-bold"></span>
                                    </td>
                                    <td>
                                        <input type="text" id="debit" class="form-control" placeholder="Debit">
                                        <span class=" error text-red text-bold"></span>
                                    </td>
                                    <td>

                                        <button class="btn btn-info text-right" id="add_new" type="button"><i
                                                class="fa fa-plus"></i>
                                        </button>

                                    </td>
                                </tr>
                                @foreach ($editInfo->details as $details)
                                    <tr>
                                        <td>
                                            {{ $details->account->account_name }}
                                            <input type="hidden" value="{{ $details->account_id }}"
                                                name="account_id[]">
                                        </td>
                                        <td>
                                            {{ $details->payment_invoice }} <input type="hidden" readonly
                                                value="{{ $details->payment_invoice }}" name="payment_invoice[]">
                                        </td>
                                        <td>
                                            <input class="{{ $details->debit ? 'd-none' : '' }}" type="number"
                                                value="{{ $details->credit }}" name="credit[]">
                                        </td>
                                        <td>
                                            <input class="{{ $details->credit ? 'd-none' : '' }}" type="number"
                                                value="{{ $details->debit }}" name="debit[]">
                                        </td>
                                        <td>
                                            <a class="btn btn-danger remove_item" style="white-space: nowrap"
                                                href="javascript:;" title="Delete Item">
                                                <i class="fa fa-trash"></i>
                                            </a>

                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td class="text-right"><strong>Sub-Total(BDT)</strong></td>
                                    <td class="text-right"></td>
                                    <td class="text-right" id="creditTotal"></td>
                                    <td class="text-right" id="debitTotal"></td>
                                </tr>
                            </tfoot>
                        </table>
                        <div class="col-md-12 mb-3">
                            <label for="validationCustom01">Note :</label>
                            <textarea type="text" id="note" name="note" rows="5" class="form-control" placeholder="Note">{{ $editInfo->note }}</textarea>
                            <span class="error text-red text-bold"></span>
                        </div>
                        <button class="btn btn-info" id="getsubmit" type="submit"><i class="fa fa-save"></i>
                            &nbsp;Save</button>
                        {{-- <a href="{{ route('settings.credit.voucher.approve', $editInfo->id) }}"
                            onclick="return confirm(`Are You Sure!`)"class="btn btn-info"><i class="fa fa-save"></i>
                            &nbsp;Approve</a> --}}
                    </div>
                </form>
            </div>
        </div>
        <!-- /.col-->
    </div>



    <script>
       $(document).ready(function() {
    // Initialize date picker
    $('#reservationdate').datetimepicker({
        format: 'YYYY-MM-DD'
    });

    // Handle cost center selection
    function toggleCostCenterFields(value) {
        $('#project_div, #branch_div').hide();
        if (value === 'project') $('#project_div').show();
        else if (value === 'branch') $('#branch_div').show();
    }
    toggleCostCenterFields($('#cost_center').val());
    $('#cost_center').change(function() {
        toggleCostCenterFields(this.value);
    });

    // Handle account type selection (CR/DR)
    $('select[name="type"]').change(function() {
        if (this.value === 'DR') {
            $('#credit').prop('disabled', true).val('');
            $('#debit').prop('disabled', false);
        } else {
            $('#debit').prop('disabled', true).val('');
            $('#credit').prop('disabled', false);
        }
    }).trigger('change');

    // Handle account selection to show invoices
    $('#account_id').change(function() {
        var accountId = $(this).val();
        $('#payment-options-container').empty();

        if (accountId) {
            $.ajax({
                url: '{{ route('settings.dabit.voucher.checkBillByBill') }}',
                type: 'GET',
                data: { account_id: accountId },
                success: function(response) {
                    if (response.bill_by_bill) {
                        $('#payment-options-container').html(`
                            <select class="form-control select2" id="payment_invoice">
                                <option value="">Select Invoice</option>
                                ${response.payment_invoices.map(invoice => 
                                    `<option value="${invoice.invoice}" data-amount="${invoice.amount}">
                                        ${invoice.invoice} (${invoice.amount})
                                    </option>`
                                ).join('')}
                            </select>
                        `);
                        $('.select2').select2(); // Reinitialize Select2
                    }
                }
            });
        }
    });

    // Auto-fill amount when invoice is selected
    $(document).on('change', '#payment_invoice', function() {
        var amount = $(this).find('option:selected').data('amount');
        if (amount) {
            var selectedType = $('select[name="type"]').val();
            if (selectedType === 'CR') {
                $('#credit').val(amount);
                $('#debit').val('');
            } else {
                $('#debit').val(amount);
                $('#credit').val('');
            }
        }
    });

    // Add new row to the table
    $(document).on('click', '#add_new', function() {
        let account_id = $('#account_id').val();
        let account_text = $('#account_id option:selected').text();
        let credit = $('#credit').val();
        let debit = $('#debit').val();
        let payment_invoice = $('#payment_invoice').val() || '';
        let type = $('select[name="type"]').val();

        // Validation
        if (!account_id) {
            alert('Please select an account');
            return;
        }
        if (!credit && !debit) {
            alert('Please enter an amount');
            return;
        }

        // Add new row
        let newRow = `
        <tr>
            <td>
                <span>${account_text}</span>
                <input type="hidden" name="account_id[]" value="${account_id}">
            </td>
            <td>
                <input type="hidden" name="payment_invoice[]" value="${payment_invoice}">
                ${payment_invoice}
            </td>
            <td>
                <input type="number" name="credit[]" value="${type === 'CR' ? credit : ''}" ${type === 'DR' ? 'disabled' : ''}>
            </td>
            <td>
                <input type="number" name="debit[]" value="${type === 'DR' ? debit : ''}" ${type === 'CR' ? 'disabled' : ''}>
            </td>
            <td>
                <button class="btn btn-danger remove_row" type="button">
                    <i class="fa fa-trash"></i>
                </button>
            </td>
        </tr>`;
        
        $('#main-table').append(newRow);
        
        // Clear inputs
        $('#account_id, #payment_invoice').val('').trigger('change');
        $('#credit, #debit').val('');
        $('#payment-options-container').empty();
        
        // Update totals
        updateTotals();
    });

    // Remove row
    $(document).on('click', '.remove_row', function() {
        if (confirm('Are you sure you want to remove this item?')) {
            $(this).closest('tr').remove();
            updateTotals();
        }
    });

    // Update totals function
    function updateTotals() {
        let creditTotal = 0;
        let debitTotal = 0;
        
        $('input[name="credit[]"]').each(function() {
            creditTotal += parseFloat($(this).val()) || 0;
        });
        
        $('input[name="debit[]"]').each(function() {
            debitTotal += parseFloat($(this).val()) || 0;
        });
        
        $('#creditTotal').text(creditTotal.toFixed(2));
        $('#debitTotal').text(debitTotal.toFixed(2));
    }

    // Form submission validation
    $('#getform').submit(function(e) {
        let creditTotal = 0;
        let debitTotal = 0;
        
        $('input[name="credit[]"]').each(function() {
            creditTotal += parseFloat($(this).val()) || 0;
        });
        
        $('input[name="debit[]"]').each(function() {
            debitTotal += parseFloat($(this).val()) || 0;
        });
        
        if (creditTotal !== debitTotal) {
            e.preventDefault();
            alert('Error: Credit and Debit totals must be equal');
        }
    });
});
    </script>
@endsection
