@extends('backend.layouts.master')

@section('title')
Report - {{ $title }}
@endsection

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }

    @media print {
        .no-print { display: none !important; }
        .print-area { margin: 0; padding: 0; }
        table { font-size: 12px; }
    }
</style>
@endsection

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Report</h1>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">

        @if($errors->any())
        <div class="card">
            <div class="card-body">
                <div class="text-danger">
                    <h4><i class="fa fa-bell" style="color:red"></i> {{ $errors->first() }}</h4>
                </div>
            </div>
        </div>
        @endif

        <!-- Filter Form -->
        <form action="{{ route('report.stock.stock') }}" method="POST" id="stocksub" enctype="multipart/form-data">
            @csrf
            <div class="card card-outline card-info no-print">
                <div class="card-body">
                    <div class="row no-print">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Date Range:</label>
                                <input type="text" class="form-control" name="dateRange" id="reservation"
                                    value="{{ old('dateRange', $dateRange) }}" />
                                @error('dateRange') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Branch</label>
                              <select class="form-control select2" name="branch_id">



                                
   
   
      


                             @if(auth()->user()->role_id > 1)
                              
                                    @foreach ($branch as $key => $value)
                                        <option value="{{ $value->id }}" {{auth()->user()->branch_id == $value->id ? 'selected' :''}}>{{ $value->name }}</option>
                                    @endforeach
                                    @else 

                                   @foreach ($branch as $key => $value)
                                        <option value="{{ $value->id }} {{ $branch_id == $value->id ? 'selected' : '' }}">{{ $value->name }}</option>
                                    @endforeach
                                    @endif
  
                                    </select>

                                @error('branch_id') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Accessories</label>
                                <select class="select2 form-control" name="product_id" data-placeholder="Search Accessories">
    <option value="all" {{ $product_id == 'all' ? 'selected' : '' }}>All Accessories</option>
    @foreach ($accressorise as $eachInfo)
        <option value="{{ $eachInfo->id }}" 
            {{ $product_id == $eachInfo->id ? 'selected' : '' }}>
            {{ $eachInfo->name }}
        </option>
    @endforeach
</select>

                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Unit</label>
              <select class="select2 form-control" name="unit" data-placeholder="Search Units">
    <option value="all" {{ $unit == 'all' ? 'selected' : '' }}>All Units</option>
    @foreach ($units as $u)
        <option value="{{ $u }}" {{ $unit == $u ? 'selected' : '' }}>{{ $u }}</option>
    @endforeach
</select>


                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <button type="submit" class="btn btn-sm btn-success">
                                    <i class="fa fa-search"></i> Search
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    @if ($StockDetails->isNotEmpty())
    <div class="col-md-12">
        <div class="card card-default print-area">
            <div class="card-header no-print">
                <h3 class="card-title">Stock In Detail</h3>
                <a onclick="window.print()" class="btn btn-default float-right my-2 no-print">
                    <i class="fas fa-print"></i> Print
                </a>
            </div>

            <div class="card-body">
                <div class="invoice p-3 mb-3">
                    <div class="row">
                        <div class="col-12 table-responsive">
                            <table class="table table-bordered">
                                <tr>
                                    <td style="text-align:center">
                                        @if ($companyInfo && $companyInfo->logo)
                                            <a href="{{ route('home') }}">
                                                <img width="200px" src="{{ asset('/backend/logo/' . $companyInfo->logo) }}" alt="">
                                            </a>
                                        @endif
                                    </td>
                                    <td width="70%" style="text-align:center">
                                        <h3>Stock In Detail</h3>
                                        <h4>
                                            <b>From Date: {{ $from_date }}</b>, 
                                            <b>To Date: {{ $to_date }}</b>
                                        </h4>
                                    </td>
                                </tr>
                            </table>

                            <table id="datatablexcel" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Date</th>
                                        <th>Product</th>
                                         <th>Unit</th>
                                        <th class="text-right">Quantity</th>
                                        <th class="text-right">KG</th>
                                        <th class="text-right">Avg Unit Price</th>
                                        <th class="text-right">Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($StockDetails as $item)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $item->created_at->format('Y-m-d') }}</td>

                                            <td>{{ $item->accessories->name }}</td>
                                             <td>{{ $item->accessories->unit }}</td>
                                            <td class="text-right">{{ $item->in_quantity }}</td>
                                            <td class="text-right">{{ $item->kg }}</td>
                                             <td class="text-right">{{ $item->price }}</td>
                                            <td class="text-right">{{ $item->total_price }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center text-danger">NO DATA RECORDS</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="4" class="text-right">Total</th>
                                        <th class="text-right">{{ $totals['qty'] }}</th>
                                          <th class="text-right">{{ $totals['kg'] }}</th>
                                        <th class="text-right">{{ $totals['unitprc'] }}</th>
                                        <th class="text-right">{{ $totals['totalprc'] }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="col-md-4">
                            <p>Prepared By:_____________<br/>Date:____________________</p>
                        </div>
                        <div class="col-md-6 text-center"></div>
                        <div class="col-md-2">
                            <p>Approved By:________________<br/>Date:_________________</p>
                        </div>

                        <div class="col-md-12 bg-success text-center mt-3">
                            Thank you for choosing {{ $companyInfo->company_name ?? 'N/A' }} products.
                            We believe you will be satisfied by our services.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

@section('scripts')
@include('backend.pages.reports.excel')
<script>
$(document).ready(function () {
    $('#stocksub').on('submit', function () {
        var product_id = $(".proName").find('option:selected').val();
        if(product_id){
            $(this).append('<input type="hidden" name="product_id" value="' + product_id + '" />');
        }
    });
});


$('#reservation').daterangepicker({
    autoUpdateInput: false,
    locale: { cancelLabel: 'Clear' }
});

@if(!empty($dateRange))
    $('#reservation').val("{{ $dateRange }}");
@endif

</script>
@endsection
