@extends('backend.layouts.master')
@section('title')
    Report - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection
@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Report </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('project.project.index'))
                            <li class="breadcrumb-item"><a href="{{ route('project.project.index') }}">Project</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span>Project List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Stock Summary</h3>
                    <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2 no-print"><i
                            class="fas fa-print"></i>
                        Print</a>

                    <form action="{{ route('inventorySetup.currentStock.index') }}" method="post">
                        @csrf
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <label for="categorysubmit">Search By Category</label>
                                <select name="category_id" id="categorysubmit" class="form-control select2">
                                    <option selected value="all">All Category</option>
                                    @foreach ($categorys as $category)
                                        <option {{ $request->category_id == $category->id ? 'selected' : '' }}
                                            value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">

                    <div class="invoice p-3 mb-3">
                        <!-- Table row -->
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Branch</th>
                                            <th>Product</th>
                                            <th>Type</th>
                                            <th>WearHouse Name</th>
                                            <th class="text-right">Qty</th>
                                            @if (auth()->user()->type == 'Admin')
                                                <th class="text-right">Avg Unit Price</th>
                                                <th class="text-right">Total</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                            $totalQty = 0;
                                            $totalPrice = 0;
                                        @endphp
                                        @foreach ($currentSrock as $item)
                                            @if ($item->stock_qty > 0)
                                                @if ($item->type != 'Project')
                                                    @php
                                                        $totalQty += $item->stock_qty;
                                                    @endphp
                                                    <tr>
                                                        <td>{{ $i++ }}</td>
                                                        <td>{{ optional($item->branch)->branchCode . ' - ' . optional($item->branch)->name }}
                                                        </td>
                                                        <td>{{ optional(optional($item->products)->category)->name . '-' . optional($item->products)->name ?? 'N/A' }}
                                                        </td>
                                                        <td align="right">{{ $item->purchasetype }}</td>
                                                        <td align="right">{{ optional($item->branch)->name }}</td>
                                                        <td align="right">{{ $item->stock_qty }}</td>

                                                        @if (auth()->user()->type == 'Admin')
                                                            <td align="right">
                                                                @php
                                                                    $purchasesPrices = App\Models\PurchasesDetails::where(
                                                                        'product_id',
                                                                        $item->product_id,
                                                                    )->pluck('unit_price');
                                                                    $openingStockPrices = App\Models\ProductOpeningStockDetails::where(
                                                                        'product_id',
                                                                        $item->product_id,
                                                                    )->pluck('unit_price');

                                                                    // Combine the prices into a single collection
                                                                    $allPrices = $purchasesPrices->merge(
                                                                        $openingStockPrices,
                                                                    );
                                                                    $avgPrice = $allPrices->avg();
                                                                @endphp
                                                                {{ $avgPrice }}
                                                            </td>
                                                            <td align="right">{{ round($avgPrice * $item->stock_qty, 2) }}
                                                            </td>
                                                        @endif
                                                    </tr>
                                                @endif
                                            @endif
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3" style="text-align: center">Total</th>
                                            <th style="text-align: right;"></th>
                                            <th style="text-align: right;"></th>
                                            <th style="text-align: right;">{{ $totalQty }}</th>
                                            @if (auth()->user()->type == 'Admin')
                                                <th style="text-align: right;"></th>
                                                <th style="text-align: right;"></th>
                                            @endif
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>




                            <div class="col-md-4  float-left">
                                <br>
                                <br>

                                <p>Prepared By:_____________<br />
                                    Date:____________________
                                </p>
                            </div>
                            <div class="col-md-6 text-center">
                            </div>
                            <div class="col-md-2  ">
                                <br>
                                <br>
                                <p>Approved By:________________<br />
                                    Date:_________________</p>
                            </div>

                            <hr>


                            <div class="col-md-12 bg-success" style="text-align: center">
                                Thank you for choosing {{ $companyInfo->company_name ?? 'N/A' }} Company products.
                                We believe you will be satisfied by our services.
                            </div>
                            <!-- /.col -->



                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#categorysubmit').on('change', function() {
                let form = $(this).closest('form');
                form.submit();
            })
        });
    </script>
@endsection
