@extends('backend.layouts.master')

@section('title')
    {{ __('Order List') . ' - ' . $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ __('Order List') }} </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a
                                href="{{ !Auth::guard('web')->user() ? route('buyer.dashboard') : route('home') }}">{{ __('Dashboard') }}</a>
                        </li>
                        @if (helper::roleAccess('order.index'))
                            <li class="breadcrumb-item">
                                <a href="{{ route('order.index') }}">{{ __('Order') }}</a>
                            </li>
                        @endif
                        <li class="breadcrumb-item active">
                            <span>{{ __('Order List') }}</span>
                        </li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <section class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">{{ __('Order List') }}</h3>
                    <div class="card-tools">
                        @if (!Auth::guard('web')->user())
                            <a class="btn btn-sm btn-default" href="{{ route('buyer.order.create') }}">
                                <i class="fas fa-plus"></i>
                                <span>{{ __('Add New') }}</span>
                            </a>
                        @endif
                  
                        @if (auth()->user()->type == 'Admin')
                            <a class="btn btn-sm btn-default" href="{{ route('order.create') }}">
                                <i class="fas fa-plus"></i>
                                <span>{{ __('Add New') }}</span>
                            </a>
                        @endif
                  
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <span id="buttons"></span>
                    <div class="table-responsive my-2">
                        <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>{{ __('SL') }}</th>
                                    @if (Auth::guard('web')->user())
                                        <th>{{ __('Buyer Name') }}</th>
                                        <th>{{ __('Company Name') }}</th>
                                    @endif
                                    {{-- <th>{{ __('Order Code') }}</th> --}}
                                    <th>{{ __('Style No') }}</th>
                                    <th>{{ __('PO Number') }}</th>
                                    <th width="100px">{{ __('Order Date') }}</th>
                                    <th width="100px">{{ __('Amount') }}</th>
                                    <th>{{ __('Note') }}</th>
                                    @if (!Auth::guard('web')->user())
                                        <th width="80px">{{ __('Status') }}</th>
                                        <th width="150px">{{ __('Approve/Reject') }}</th>
                                    @endif
                                    <th width="70px">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($orders as $order)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        @if (Auth::guard('web')->user())
                                            <td>{{ $order->buyer->name }}</td>
                                            <td>{{ $order->buyer->company_name }}</td>
                                        @endif
                                        {{-- <td>{{ $order->order_code }}</td> --}}
                                        <td>{{ $order->style_no }}</td>
                                        <td>{{ $order->po_number }}</td>
                                        <td>{{ $order->created_at->format('d-m-Y') }}</td>
                                        <td>{{ number_format($order->amount, 2) . '/-' }}</td>
                                        <td style="text-align: left;">
                                          {!! $order->note ?? 'N/A' !!}
                                      </td>
                                      
                                        @if (!Auth::guard('web')->user())
                                            <td>
                                                <span
                                                    class="badge bg-{{ $order->status == 'Approved' ? 'success' : ($order->status == 'Rejected' ? 'danger' : 'secondary') }}">{{ $order->status }}</span>
                                            </td>
                                        @endif
                                        @if (!Auth::guard('web')->user())
                                            <td>
                                                @if ($order->status == 'Approved')
                                                    {{ $order->approvedUser->name ?? 'N/A' }}
                                                @elseif ($order->status == 'Rejected')
                                                    {{ $order->rejectedUser->name }}
                                                @else
                                                    {{ __('N/A') }}
                                                @endif
                                            </td>
                                        @endif
                                        <td class="d-flex">
                                            @if (!Auth::guard('web')->user())
                                                <a href="{{ route('buyer.order.show', $order->id) }}"
                                                    class="btn btn-sm btn-success ml-1" title="Invoice">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            @else
                                                <div class="mr-2">
                                                    @if (helper::roleAccess('buyer.order.destroy'))
                                                        <button
                                                            delete_route="{{ route('buyer.order.destroy', $order->id) }}"
                                                            delete_id="{{ $order->id }}" title="Delete"
                                                            class="btn btn-sm btn-danger px-2 delete_row uniqueid{{ $order->id }}"
                                                            {{ $order->proformaInvoice ? 'disabled' : '' }}>
                                                            <i class="fas fa-trash-alt"></i>
                                                        </button>
                                                    @endif
                                                </div>
                                                <div class="mr-2">
                                                    @if ($order->status == 'Approved' || $order->status == 'Confirmed')
                                                        <input class="status_row form-controm form-controls-sm"
                                                            status_route="{{ route('order.status', [$order->id, 'Rejected']) }}"
                                                            id="toggle-demo" type="checkbox" name="my-checkbox" checked
                                                            data-bootstrap-switch data-off-color="danger"
                                                            data-on-color="success"
                                                            {{ $order->proformaInvoice ? 'disabled' : '' }}>
                                                    @else
                                                        <input class="status_row form-controm form-controls-sm"
                                                            status_route="{{ route('order.status', [$order->id, 'Approved']) }}"
                                                            id="toggle-demo" type="checkbox" name="my-checkbox"
                                                            data-bootstrap-switch data-off-color="danger"
                                                            data-on-color="success"
                                                            {{ $order->proformaInvoice ? 'disabled' : '' }}>
                                                    @endif
                                                </div>
                                                <div class="dropdown">

                                                    <button class="btn btn-sm btn-secondary dropdown-toggle pl-2 pb-0"
                                                        type="button" data-toggle="dropdown"
                                                        aria-expanded="false"></button>

                                                    <div class="dropdown-menu">
                                                        @if (helper::roleAccess('proforma.invoice.generate'))
                                                            <button type="button" class="dropdown-item"
                                                                redirect="{{ route('proforma.invoice.list') }}"
                                                                data-toggle="modal" data-target="#generatePI"
                                                                data-order-id="{{ $order->id }}"
                                                                data-buyer-id="{{ $order->buyer_id }}"
                                                                data-buyer-name="{{ $order->buyer->name }}"
                                                                data-style-no="{{ $order->style_no }}"
                                                                data-po-number="{{ $order->po_number }}"
                                                                {{ $order->proformaInvoice ? 'disabled' : '' }}>
                                                                <i class="fas fa-file-invoice"
                                                                    style="width: 1rem !important;"></i>
                                                                <span class="ml-1">{{ __('Generate Invoice') }}</span>
                                                            </button>
                                                        @endif
                                                        {{-- <a class="dropdown-item" href="javascript:void(0)">
                              <i class="fas fa-file-invoice" style="width: 1rem !important;" ></i>
                              <span class="ml-1">{{ __('Generate Invoice') }}</span>
                            </a> --}}
                                                        @if (helper::roleAccess('order.edit'))
                                                            <a class="dropdown-item"
                                                                href="{{ route('order.edit', $order->id) }}"
                                                                title="Update">
                                                                <i class="fas fa-edit" style="width: 1rem !important;"></i>
                                                                <span class="ml-1">{{ __('Edit Order') }}</span>
                                                            </a>
                                                        @endif
                                                        @if (helper::roleAccess('order.show'))
                                                            <a class="dropdown-item"
                                                                href="{{ route('order.show', $order->id) }}"
                                                                title="Invoice">
                                                                <i class="fas fa-eye" style="width: 1rem !important;"></i>
                                                                <span class="ml-1">{{ __('View Invoice') }}</span>
                                                            </a>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>{{ __('SL') }}</th>
                                    @if (Auth::guard('web')->user())
                                        <th>{{ __('Buyer Name') }}</th>
                                        <th>{{ __('Company Name') }}</th>
                                    @endif
                                    <th>{{ __('Style No.') }}</th>
                                    <th>{{ __('PO Number') }}</th>
                                    <th>{{ __('Order Date') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                    <th>{{ __('Note') }}</th>
                                    @if (!Auth::guard('web')->user())
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Approve/Reject') }}</th>
                                    @endif
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div><!-- /.card-body -->
                <div class="card-footer"></div>
            </div>
        </div><!-- /.col-->
        <form action="" method="post">
            @method('delete')
        </form>
    </section>

    <!-- Modal -->
    <section class="modal fade" id="generatePI" tabindex="-1" aria-labelledby="generatePILabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form id="generatePIForm" action="{{ route('proforma.invoice.generate') }}" method="POST">
                    @csrf
                    <div class="modal-header py-2">
                        <h5 class="modal-title" id="generatePILabel">{{ __('Generate Proforma Invoice') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <input type="hidden" name="order_id" id="orderID" />
                            <div class="col-md-6 mb-3">
                                <label for="piNumber">{{ __('PI Number') }}</label>
                                <input type="text" name="pi_number" class="form-control form-control-sm"
                                    id="piNumber" required />
                                @error('pi_number')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="buyerID">{{ __('Buyer\'s Name') }}</label>
                                <select name="buyer_id" class="form-control form-control-sm" id="buyerID"
                                    required></select>
                                {{-- <input type="text" class="form-control form-control-sm" id="buyerID" readonly /> --}}
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="styleNo">{{ __('Style No') }}</label>
                                <input type="text" class="form-control form-control-sm" id="styleNo" required
                                    readonly />
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="poNumber">{{ __('PO Number') }}</label>
                                <input type="text" class="form-control form-control-sm" id="poNumber" required
                                    readonly />
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="piDate">{{ __('PI Date * :') }}</label>
                                <div class="input-group input-group-sm date" id="reservationdate1"
                                    data-target-input="nearest">
                                    <input type="text" id="piDate" name="pi_date" data-toggle="datetimepicker"
                                        value="{{ old('pi_date', date('Y-m-d')) }}"
                                        class="form-control datetimepicker-input" data-target="#reservationdate1"
                                        required />
                                    <div class="input-group-append" data-target="#reservationdate1"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                </div>
                                @error('pi_date')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="vatNumber">{{ __('VAT Number * :') }}</label>
                                <input type="text" name="vat_number" class="form-control form-control-sm"
                                    id="vatNumber" placeholder="Vat Number" value="{{ old('vat_number') }}" required />
                                @error('vat_number')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer py-1">
                        <button type="button" class="btn btn-primary generate"
                            id="generate">{{ __('Generate') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            var table = $('#systemDatatable').DataTable({
                // DataTable configuration options go here
            });

            var buttons = new $.fn.dataTable.Buttons(table, {
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ]
            }).container().appendTo($('#buttons'));
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#generatePI').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var redirect = button.attr('redirect');
                var orderID = button.data('order-id');
                var buyerID = button.data('buyer-id');
                var buyerName = button.data('buyer-name');
                var styleNo = button.data('style-no');
                var poNumber = button.data('po-number');
                var option = '<option value="' + buyerID + '">' + buyerName + '</option>';
                $('#orderID').val(orderID);
                $('#styleNo').val(styleNo);
                $('#poNumber').val(poNumber);
                $('#buyerID').html(option);

                $('#generate').click(function() {
                    if (validateForm()) {
                        // $('#generatePIForm').submit();
                        // window.location.href = redirect;
                        $.ajax({
                            url: $('#generatePIForm').attr('action'),
                            method: 'POST',
                            data: $('#generatePIForm').serialize(),
                            success: function(response) {
                                // If successful, redirect to the specified URL
                                window.location.href = redirect;
                            },
                            error: function(xhr, status, error) {
                                // Handle error if necessary
                                console.error(error);
                            }
                        });
                    }
                });

                function validateForm() {
                    var piNumber = $('#piNumber').val();
                    var piDate = $('#piDate').val();
                    var vatNumber = $('#vatNumber').val();

                    if (piNumber.trim() === '') {
                        alert('Please enter PI Number.');
                        return false;
                    }
                    if (piDate.trim() === '') {
                        alert('Please select PI Date.');
                        return false;
                    }
                    if (vatNumber.trim() === '') {
                        alert('Please enter VAT Number.');
                        return false;
                    }

                    return true;
                }
            });
        });
    </script>
@endsection
