@extends('backend.layouts.master')
@section('title')
    Sale - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6" style="display: flex;gap:10px;border: 1px solid red;
    padding: 5px;
}">
                   @if (!empty($supplier->image))
    <img src="{{ asset('/backend/logo/' . $supplier->image) }}"
         style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
         alt="Supplier Image">
@else
    <img src="{{ asset('/backend/logo/default.png') }}"
         style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 3px solid #ccc;"
         alt="Default Supplier Image">
@endif

                    <div style="font-weight: bold;font-size:24px; font-weight:bold">
                        <p style="padding: 2px; margin-bottom: -12px;">{{ $supplier->name }}</p>
                        <p style="padding: 2px; margin-bottom: -12px;">{{ $supplier->phone }}</p>
                        <p style="padding: 2px; margin-bottom: -12px;"> {{ $supplier->address }}</p>
                    </div>

                </div><!-- /.col -->
                 <div class="col-sm-2" style="text-align: center; font-weight:900">
                   
                </div>
                <div class="col-sm-4" style="text-align: center; font-weight:900">
                    <div style="border: 1px solid #ccc; padding: 10px; margin-bottom: 5px; border-radius: 5px;">
                        Total DUE
                    </div>
                    <div style="border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
                        {{ $totalDue }} &#2547;
                    </div>
                </div>

            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Supplier Due List</h3>
                    <div class="card-tools">

                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <div class="mb-3" style="display: flex;gap:10px">
                   <form method="GET" action="{{ route('inventorySetup.supplier.show', $supplier->id) }}" class="mb-3" style="display: flex; gap: 10px;">
    <div>
        <label for="from_date">From:</label>
        <input type="date" id="from_date" class="form-control" name="from_date" value="{{ request('from_date') }}">
    </div>

    <div>
        <label for="to_date">To:</label>
        <input type="date" id="to_date" class="form-control" name="to_date" value="{{ request('to_date') }}">
    </div>

    <div style="align-self: end;">
        <button type="submit" class="btn btn-primary">Search</button>
    </div>

    <div style="align-self: end;">
        <a href="{{ route('inventorySetup.supplier.show', $supplier->id) }}" class="btn btn-secondary">Reset</a>
    </div>
</form>


                        </div>
                        <table class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>

                                    <th>Date</th>

                                    <th>Total Bill</th>
                                    <th>Total Due(&#2547;)</th>
                                    <th>Action</th>
                            </thead>
                            <tbody>
                                @foreach ($stockIn as $data)
                                @php 
                                 $paymentTotal = App\Models\AccountTransaction::where('table_id',$data->id)->where('account_id',$data->ledger_id)->sum('debit');
                                  $paymentTotalPaid = \App\Models\AccountTransaction::where('table_id',$data->id)->where('account_id',$data->ledger_id)->sum('credit');
                                 $due =  $paymentTotalPaid - $paymentTotal;
                             
                             @endphp
                                    <tr>
                                        <td>{{$loop->index + 1}}</td>
                                        <td>{{$data->date}}</td>
                                        <td>{{$data->ngrandTotal}}</td>
                                        <td>{{$due}}</td>
                                        <td>
                                              <a href="{{ route('stockin.show', $data->id) }}" class="btn btn-info btn-sm ml-2">
                                            <i class="bi bi-eye"></i> Show
                                        </a>
                                           <a href="{{ route('stockin.edit', $data->id) }}" class="btn btn-info btn-sm ml-2">
                                            <i class="bi bi-eye"></i> Edit
                                        </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>

                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
@endsection
