@extends('backend.layouts.master')

@section('title')
  {{ __('inventory') . ' - ' . $title}}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Inventory') }} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('inventorySetup.product.index'))
              <li class="breadcrumb-item">
                <a href="{{route('inventorySetup.product.index') }}">{{ __('Product') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ __('Product List') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  @if ($buyer->status == 'Active')
    <section class="row">
      <div class="col-md-12">
        <div class="card card-default h-100">
          <div class="card-header">
            <div class="row">
              <div class="col-md-12 mb-3">
                @foreach ($categories as $index => $category)
                  <a href="javascript:void(0)" class="btn btn-sm btn-secondary rounded-pill mb-1 category-btn" style="{{ $index > 10 ? 'display: none;' : '' }}" data-category-id="{{ $category->id }}" >
                    <span>{{ $category->name }}</span>
                  </a>
                @endforeach
                <button id="toggle-categories" class="btn btn-sm btn-light rounded-pill mb-1">
                  <i class="fas fa-chevron-down"></i>
                </button>
              </div>
            </div>
          </div>
          <div class="card-body">
            <div class="row">
              @foreach ($products as $product)
                <div class="col-md-2">
                  <a href="javascript:void(0)" title="{{ $product->name }}" class="product" product-name="{{ $product->name }}" product-thumbnail="{{ asset('uploads/products/'.$product->thumbnail) }}" product-price="{{ $product->sale_price }}" data-category-id="{{ $product->category_id }}" >
                    <div class="card card-outline card-primary" >
                      <img src="{{ $product->thumbnail ? asset('uploads/products/'.$product->thumbnail) : 'https://via.placeholder.com/150x150' }}" class="card-img-top" height="120px" alt="..." />
                      <div class="card-body px-3 py-1">
                        <h5 class="card-title">{{ substr($product->name, 0, 20) . '...' }}</h5>
                      </div>
                    </div>
                  </a>
                </div>
              @endforeach
            </div>
            <div class="pagination justify-content-center">
              {{ $products->links() }}
            </div>        
          </div>
        </div>
      </div>
      <div class="col-md-12 mt-5">
        <form action="{{ route('buyer.order.store') }}" method="POST" enctype="multipart/form-data" />
          @csrf
          <div class="card card-default h-100">
            <div class="card-header">
              <!-- Button trigger modal -->
              <button type="button" class="btn btn-sm btn-secondary" data-toggle="modal" data-target="#staticBackdrop">
                {{ __('Custom Order') }}
              </button>
              {{-- <span class="badge bg-warning ml-3">{{ $orderCode }}</span> --}}
            </div>
            <div class="card-body">
              <input type="hidden" name="order_code" value="{{ $orderCode }}" />
              <input type="hidden" name="amount" id="amount" value="0">
              <table class="table table-borderless table-striped table-hover">
                <thead class="table-secondary">
                  <tr>
                    <th>{{ __('Product') }}</th>
                    <th width="150px">{{ __('Quantity') }}</th>
                    <th width="150px">{{ __('Price') }}</th>
                    <th width="150px">{{ __('Subtotal') }}</th>
                    <th width="50px">{{ __('Action') }}</th>
                  </tr>
                </thead>
                <tbody></tbody>
                <tfoot class="table-light">
                  <tr>
                    <td class="text-right" colspan="3" >
                      <strong>{{ __('Total =') }}</strong>
                    </td>
                    <td class="text-right" colspan="2"></td>
                  </tr>
                </tfoot>
              </table>
            </div>
            <div class="card-footer">
              <button type="submit" class="btn btn-primary">
                <span>{{ __('Place Your Order') }}</span>
              </button>
            </div>
          </div>
        </form>
      </div>
    </section>

    <!-- Modal -->
    <section class="modal fade" id="staticBackdrop" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            ...
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary">Understood</button>
          </div>
        </div>
      </div>
    </section>
  @endif
@endsection

@section('scripts')
  <script>
    $(document).ready(function () {
      $('.product').click(function () {
        var productName = $(this).attr('product-name');
        var existingRow = $('tbody').find('tr[data-product-name="' + productName + '"]'); 
        if (existingRow.length > 0) {
          var input = existingRow.find('.quantity');
          var currentValue = parseInt(input.val());
          input.val(currentValue + 1);
          updateSubtotal(existingRow);
        } else {
          var thumbnail = $(this).attr('product-thumbnail');
          var qty = 1;
          var price = parseFloat($(this).attr('product-price'));
          addProductRow(productName, thumbnail, qty, price);
        }
      });

      $(document).on('click', '.increment', function() {
        var row = $(this).closest('tr');
        var input = row.find('.quantity');
        var currentValue = parseInt(input.val());
        input.val(currentValue + 1);
        updateSubtotal(row);
      });

      $(document).on('click', '.decrement', function() {
        var row = $(this).closest('tr');
        var input = row.find('.quantity');
        var currentValue = parseInt(input.val());
        if (currentValue > 1) {
          input.val(currentValue - 1);
          updateSubtotal(row);
        }
      });

      $(document).on('click', '.delete-product', function() {
        if (confirm('Are you sure you want to delete this product?')) {
          deleteProductRow($(this).closest('tr'));
        }
      });

      function addProductRow(productName, thumbnail, qty, price) {
        var subtotal = qty * price;
        var newRow = '<tr data-product-name="' + productName + '">' +
          '<td>' +
          '<div class="row">' +
          '<div class="col-1">' +
          '<img src="'+thumbnail+'" class="rounded" width="40px" height="40px" alt="" />' +
          '<input type="hidden" name="thumbnail[]" value="' + thumbnail + '">' +
          '</div>' +
          '<div class="col-11">' +
          '<strong class="ml-2">' + productName + '</strong>' +
          '</div>' +
          '</div>' +
          '<input type="hidden" name="product_name[]" value="' + productName + '">' +
          '</td>' +
          '<td>' +
          '<div class="input-group input-group-sm">' +
          '<button type="button" class="btn btn-sm btn-secondary rounded-0 increment">' +
          '<i class="fas fa-plus"></i>' +
          '</button>' +
          '<input type="text" name="quantity[]" class="form-control text-center rounded-0 quantity" value="' + qty + '" readonly />' +
          '<button type="button" class="btn btn-sm btn-secondary rounded-0 decrement">' +
          '<i class="fas fa-minus"></i>' +
          '</button>' +
          '</div>' +
          '</td>' +
          '<td class="text-right price">' + price.toFixed(2) + '/-</td>' +
          '<td class="text-right subtotal">' + subtotal.toFixed(2) + '/-</td>' +
          '<td class="text-center">' +
          '<button type="button" class="btn btn-sm btn-danger delete-product">' +
          '<i class="fas fa-trash-alt"></i>' +
          '</button>' +
          '</td>' +
          '<input type="hidden" name="rate[]" value="' + price + '">' +
          '<input type="hidden" name="price[]" value="' + subtotal + '">' +
          '</tr>';
        $('tbody').append(newRow);
        updateTotals();
        updateTotalInput();
      }

      function deleteProductRow(row) {
        row.remove();
        updateTotals();
        updateTotalInput();
      }

      function updateSubtotal(row) {
        var quantity = parseInt(row.find('.quantity').val());
        var price = parseFloat(row.find('.price').text());
        var subtotal = quantity * price;
        row.find('.subtotal').text(subtotal.toFixed(2) + '/-');
        updateTotals();
        updateTotalInput();
      }

      function updateTotals() {
        var total = 0;
        $('tbody').find('.subtotal').each(function() {
          var subtotalText = $(this).text();
          var subtotal = parseFloat(subtotalText.substring(0, subtotalText.length - 2));
          total += subtotal;
        });
        $('tfoot').find('tr:first td:last').text(total.toFixed(2) + '/-');
        // var grandTotal = total;
        // $('tfoot').find('tr:last td:last').text(grandTotal.toFixed(2) + '/-');
      }

      function updateTotalInput() {
        var total = 0;
        $('.subtotal').each(function() {
          var subtotalText = $(this).text();
          var subtotal = parseFloat(subtotalText.substring(0, subtotalText.length - 3));
          total += subtotal;
        });
        $('#amount').val(total.toFixed(2));
      }

      $('.category-btn').slice(10).hide();

      $('#toggle-categories').click(function() {
        $('.category-btn').slice(10).toggle();
        $(this).find('i').toggleClass('fa-chevron-down fa-chevron-up');
      });

      $('.category-btn').click(function() {
        var categoryId = $(this).data('category-id');
        $('.product').hide();
        $('.product[data-category-id="' + categoryId + '"]').show();
      });

      updateTotals();
      updateTotalInput();

    });
  </script>
@endsection