@extends('backend.layouts.master')
@section('title')
    inventory - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
   <div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <!-- Left Column -->
            <div class="col-sm-6">
                <h1 class="m-0">Inventory</h1>
            </div>

            <!-- Right Column -->
            <div class="col-sm-6 d-flex justify-content-end">
                <div style="display: flex; gap: 10px; border: 1px solid; font-weight: bold; padding: 5px; align-items: center;">
                    <h1 class="m-0" style="border-right: 1px solid; padding-right: 5px;">Customer</h1>
                    <h1 class="m-0" style="padding-left: 5px;">{{$customerCount}} </h1>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Customer List</h3>
                    <div class="card-tools">
                       
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer Name</th>
                                   
                              
                                    <th>Phone</th>
                                    <th>Address</th>
                                   <th> Total Sale(&#2547;)</th>
                                     <th> Total Due(&#2547;)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer Name</th>
                                 
                                    
                                  
                                    <th>Phone</th>
                                    <th>Address</th>
                                     <th> Total Sale</th>
                                     <th> Total Due</th>
                                   
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
@endsection
@section('scripts')
    @include('backend.pages.inventories.customer.customerScript')
@endsection
