@extends('backend.layouts.master')
@section('title')
    Hrm - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }

        div#ui-datepicker-div {
            background: #fff;
            padding: 10px 20px;
            margin-top: -6px;
            border: 1px solid #e6e6e6;
        }

        div#ui-datepicker-div table tbody tr td {
            border: 1px solid rgb(173, 173, 173)
        }

        div#ui-datepicker-div table tbody tr td a {
            color: #000
        }

        @media print {
            @page {
                size: A4 landscape;
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
                font-size: 11px;
            }

            .btn,
            .paynow,
            .fa-money-bill {
                display: none !important;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                border: 1px solid #000;
                padding: 4px;
                word-break: break-word;
            }

            h5 {
                margin: 0;
                padding: 10px 0;
                text-align: center;
            }



        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        HRM </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        {{-- @if (helper::roleAccess('inventorySetup.adjust.index'))
                            <li class="breadcrumb-item"><a href="{{ route('hrm.attendance.index') }}">Hrm</a>
                            </li>
                        @endif --}}
                        <li class="breadcrumb-item active"><span>{{ $title }}</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Salary Pay Sheet</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body hide_div">
                    <form action="{{ route('hrm.paysheet.absent.deduction') }}" method="get">

                        <div class="form-group row">
                            <div class="col-md-3">
                                <label for="employe" class="mt-2">Employee:</label>
                                <select name="employee_id" class="form-control select2" id="employe">
                                    <option value="all" selected>All</option>
                                    @foreach ($employees->all() as $employee)
                                        <option {{ $request->employee_id == $employee->id ? 'selected' : '' }}
                                            value="{{ $employee->id }}">
                                            {{ $employee->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="From" class="mt-2">Select Month:</label>
                                <input type="month" id="From" value="{{ $request->month }}" class="form-control"
                                    name="month">
                                <span class="input-group-addon">
                                    <span class="glyphicon glyphicon-calendar"></span>
                                </span>
                            </div>

                            {{-- <div class="col-md-3">
                                <label for="From" class="mt-2">Date Range:</label>
                                <input type="text" class="form-control " name="dateRange" value=""
                                    id="reservation" />

                            </div> --}}
                            <div class="col-md-1" style="margin-top:38px">
                                <button class="btn btn-success">Search</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->
    </div>

    <div class="row">
        <button onclick="printShitCard()" class="btn btn-primary mb-3 ml-3">
            <!-- SVG icon -->
            Print
        </button>

        <div class="col-md-12 shit_Card">
            <div class="card card-default">
                <!-- /.card-header -->
                <div class="card-body ">

                    <h5 class="text-center mt-3">Salary Pay Sheet History </h5>
                    <table class="table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th scope="col">SL</th>
                                <th scope="col">Name</th>
                               
                               <th scope="col">Late (TLT)</th>
                                     <th scope="col">Late (3days)</th>
                                      <th scope="col">Late Salary Deduction</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            @if (isset($MonthlyPaySheets))
                                @foreach ($MonthlyPaySheets as $key => $MonthlyPaySheet)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $MonthlyPaySheet->name }}</td>
                                    
                                      <td>{{ $MonthlyPaySheet->employee_late }} </td>
                                             <td>{{ $MonthlyPaySheet->employee_late_deduction }} </td>
                                              <td>{{ $MonthlyPaySheet->employee_late_salary_deduction }}</td>
                                       
                                    </tr>
                                @endforeach
                            @elseif (isset($tables))
                                @php
                                    $total_salary = 0;
                                    $employee_payable_salary = 0;
                                @endphp
                                @foreach ($tables as $key => $table)
                                    <tr>
                                        <td>{{ $table['id_card'] }}</td>
                                        <td>{{ $table['name'] }}</td>
                                      
                                       <td>{{ $table['employee_late'] }} </td>
                                              <td>{{ $table['employee_late_deduction'] }} </td>
                                              <td>{{ $table['employee_late_salary_deduction'] }}</td> 
                                       
                                    </tr>
                                   
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="22"></td>
                                </tr>
                            @endif
                        </tbody>


                      
                    </table>


                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->

        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="card-header">
                        <h3 class="card-title">Salary Pay Sheet</h3>
                        <div class="card-tools">
                            <span id="buttons"></span>
                            <a class="btn btn-tool btn-default" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </a>
                            <a class="btn btn-tool btn-default" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </a>
                        </div>
                    </div>
                    <div class="card card-body">
                        <form class="needs-validation" action="" method="post" novalidate>
                            @csrf
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Paybale Salary</label>
                                <div class="col-md-9 mb-1">
                                    <h5 class="showpayable"></h5>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Amount <span class="text-danger">*</span></label>
                                <div class="col-md-9 mb-1">
                                    <input type="number" class="form-control payamount" min="1" required
                                        name="amount">
                                    @error('amount')
                                        <span class=" error text-red text-bold">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Payment Type <span
                                        class="text-danger">*</span></label>
                                <div class="col-md-9 mb-1">
                                    <select name="payment_type" class="form-control">
                                        <option selected disabled>Select a Method</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->account_name }}</option>
                                        @endforeach
                                    </select>
                                    @error('amount')
                                        <span class=" error text-red text-bold">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <hr>

                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Loan </span></label>
                                <div class="col-md-9 mb-1">
                                    <h5 class="showloanamount">
                                    </h5>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Loan Adjustment</span></label>
                                <div class="col-md-9 mb-1">
                                    <h5 class="showloanadj">
                                    </h5>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let from = document.getElementById("From");
            let today = new Date();
            let currentMonth = today.toISOString().slice(0, 7); // Format: YYYY-MM

            from.setAttribute("max", currentMonth);
        });

        $(document).on('click', '.paynow', function() {
            let url = $(this).attr('href');
            $('form').attr('action', url);
            let payable = $(this).closest('tr').find('.payable').text();
            $('.showpayable').text(payable)
            $('.payamount').val(Number(payable))
            let loanamount = $(this).closest('tr').find('.loanamount').text();
            $('.showloanamount').text(loanamount);
            let loanAdjustment = $(this).closest('tr').find('.loanAdjustment').text();
            $('.showloanadj').text(loanAdjustment);
        })
    </script>
    <script>
        function printShitCard() {
            var content = document.querySelector('.shit_Card').innerHTML;
            var printWindow = window.open('', '', 'height=800,width=1200');

            printWindow.document.write('<html><head><title>Print Salary Sheet</title>');

            // Optional: Include your CSS or Bootstrap
            printWindow.document.write('<link rel="stylesheet" href="{{ asset('css/app.css') }}">');

            // Custom styles for print
            printWindow.document.write(`
            <style>
                @media print {
                    @page {
                        size: A4 landscape;
                       margin: 0;
                    }
                                .no-print {
        display: none !important;
    }
                    body {
                        font-size: 12px;
                    }
                    .btn, .paynow, .fa-money-bill {
                        display: none !important;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                    }
                    table th, table td {
                        padding: 6px;
                        border: 1px solid #000;
                        word-break: break-word;
                    }


                }
            </style>
        `);

            printWindow.document.write('</head><body>');
            printWindow.document.write(content);
            printWindow.document.write('</body></html>');

            printWindow.document.close();
            printWindow.focus();

            printWindow.onload = function() {
                printWindow.print();
            };

            printWindow.onafterprint = function() {
                printWindow.close();
            };
        }
    </script>
@endsection
