@extends('backend.layouts.master')

@section('title')
    Dashboard Page - Admin Panel
@endsection
<style>
    .small-box>.small-box-footer {
        border: none;
        width: 100%;
    }

    .fixed-height-table {
        max-height: 300px;
        /* Set your desired height */
        overflow-y: auto;
    }

    .fixed-height-table thead th {
        position: sticky;
        top: 0;
        background: #343a40;
        color: #fff;
        z-index: 1;
    }

    .fixed-height-table tfoot th {
        position: sticky;
        bottom: 0;
        background: #f8f9fa;
        z-index: 1;
    }
</style>
@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Stock Report</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
    <div style="display:flex; gap:10px">
           @foreach ($currentStock as $unit => $items)
    @php
        $totalQty = 0;
        $totalKg = 0;
    @endphp

    @foreach ($items as $item)
        @php
            $accessoryId = $item->product_id;

            $total_in_kg = $stockinSums[$accessoryId] ?? 0;
            $total_in_qty = $stockinQty[$accessoryId] ?? 0;
            $rate_per_kg = $total_in_qty > 0 ? $total_in_kg / $total_in_qty : 0;

            $total_out_qty = $stockoutSums[$accessoryId] ?? 0;
            $total_out_kg = $total_out_qty * $rate_per_kg;

            $available_kg = $total_in_kg - $total_out_kg;

            $totalQty += $item->quantity;
            $totalKg += $item->kg;
        @endphp
    @endforeach

    <div style="font-size: 20px; font-weight: 900; border: 1px solid; padding-left: 10px; padding-right: 10px;">
        @if($unit === "ROOL")
          <span style="border-right

: 2px solid;
    padding-right: 2px;">{{ $unit }} {{ $totalQty }}</span> <span>KG - {{ $totalKg }}</span>  
        @elseif($unit === "PS")
            {{ $unit }} - {{ $totalQty }}
        @endif
    </div>
    
@endforeach

</div>
                    {{-- <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item active"><a href="#">Stock Report</a></li>
                    </ol> --}}
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
   


 <div class="row">


    @php
    $totalQty = 0;
    $totalKg =0;
@endphp

@foreach ($currentStock  as $unit => $items)
    <div class="col-md-12 mb-4">
        <h5 class="mb-2">{{ $unit }} Items</h5>
        <div class=" ">
            <table class="table table-bordered table-striped mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>SL</th>
                        <th>Product</th>
                        <th>Unit</th>
                        <th>Quantity</th>
                        <th>Available (KG)</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; $totalQty = 0; $totalKg = 0; @endphp
                    @foreach ($items as $item)
                        @php
                            $accessoryId = $item->product_id;

                            $total_in_kg = $stockinSums[$accessoryId] ?? 0;
                            $total_in_qty = $stockinQty[$accessoryId] ?? 0;
                            $rate_per_kg = $total_in_qty > 0 ? $total_in_kg / $total_in_qty : 0;

                            $total_out_qty = $stockoutSums[$accessoryId] ?? 0;
                            $total_out_kg = $total_out_qty * $rate_per_kg;

                            $available_kg = $total_in_kg - $total_out_kg;
                            $accessory = $item->accessories;

                            $totalQty += $item->quantity;
                            $totalKg += $item->kg;
                        @endphp
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ $accessory->name ?? 'N/A' }}</td>
                            <td>{{ $accessory->unit ?? 'N/A' }}</td>
                            <td>{{ $item->quantity }}</td>
                            <td><strong>{{ number_format($item->kg, 2) }}</strong></td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3" class="text-end">Total</th>
                        <th>{{ $totalQty }}</th>
                        <th>{{ number_format($totalKg, 2) }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
@endforeach


    </div>
   



@endsection
