@extends('backend.layouts.master')
@section('title')
    inventory - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
        .account-card {
            transition: transform 0.2s;
        }
        .account-card:hover {
            transform: translateY(-2px);
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Total Balance</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active"><span>Account Information</span></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Account Information</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    {{-- Account Cards --}}
                    <div class="row">
                         @foreach ($accountsInfo as $account)
                            @php
                                $balanceDebit = \App\Models\AccountTransaction::where('account_id', $account->id)->sum(
                                    'debit',
                                );
                            @endphp

                            <div class="col-md-4 mb-3">
                                <div class="card shadow-sm border-left-primary"
                                    style="color:#fff;background: rgb(58, 56, 56)">
                                    <div class="card-body" style="  display: flex; gap: 10px;">
                                        <h5 class="card-title">{{ $account->account_name }}-</h5>
                                        <p class="card-text">
                                            {{ number_format($balanceDebit, 2) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    {{-- Filters --}}
                    <div class="table-responsive">
                        <form method="GET" class="mb-3">
                            <div class="row">
                                <div class="col-md-3">
                                    <select name="account_id" class="form-control form-control-sm select2">
                                        <option value="">-- Select Bank --</option>
                                        <x-account :setAccounts="$accounts" />
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <input type="date" name="from_date" class="form-control"
                                        placeholder="From Date" value="{{ $request->from_date }}">
                                </div>
                                <div class="col-md-3">
                                    <input type="date" name="to_date" class="form-control"
                                        placeholder="To Date" value="{{ $request->to_date }}">
                                </div>
                                <div class="col-md-3">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> Search
                                    </button>
                                    <a href="{{ route('bank.info.dashboard') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> Reset
                                    </a>
                                </div>
                            </div>
                        </form>

                        {{-- Transaction Table --}}
                        <table class="table table-bordered table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Invoice</th>
                                    <th>Date</th>
                                    <th>Customer Name</th>
                                    <th>Advance Payment</th>
                                    <th>Due Payment</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $serial = $transactionsPaginator->firstItem() ?? 1; @endphp

                                @forelse ($transactionsPaginator as $invoice)
                                    @php
                                        $sales = App\Models\Sale::where('invoice_no', $invoice['invoice'])->first();
                                        $customer = null;

                                        if ($sales) {
                                            $ledger = App\Models\ChartOfAccount::find($sales->ledger_id);
                                            $customer = App\Models\Customer::where('id', $ledger->accountable_id)->first();
                                        }
                                        
                                        $uniqueBankNames = array_unique($invoice['bank_names']);
                                        $bankNamesDisplay = implode(', ', $uniqueBankNames);
                                    @endphp

                                    <tr>
                                        <td>{{ $serial++ }}</td>
                                        <td>
                                            <span class="badge badge-info">{{ $invoice['invoice'] }}</span>
                                        </td>
                                        <td>{{ $invoice['date'] }}</td>
                                        <td>{{ $customer->name ?? '-' }}</td>

                                        {{-- Advance Payment --}}
                                        <td>
                                         @if ($invoice['advance_payment'] > 0)
    <span class="text-success">
        {{ $invoice['advance_bank'] ?? 'N/A' }} - {{ number_format($invoice['advance_payment'], 2) }}
    </span>
@else
    <span class="text-muted">-</span>
@endif

                                        </td>

                                        {{-- Due Payment --}}
                                        <td>
                                          @if ($invoice['due_payment'] > 0)
    <span class="text-warning">
        {{ $invoice['due_bank'] ?? 'N/A' }} - {{ number_format($invoice['due_payment'], 2) }}
    </span>
@else
    <span class="text-muted">-</span>
@endif

                                        </td>
                                        <td> @if($sales)<a href="{{route('sale.sale.show', $sales->id)}}"class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>@endif</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">
                                            <div class="alert alert-info mb-0">
                                                <i class="fas fa-info-circle"></i> No transactions found.
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>

                        {{-- Pagination --}}
                        <div class="d-flex justify-content-center">
                            {!! $transactionsPaginator->appends(request()->query())->links() !!}
                        </div>
                    </div>
                </div>
                
                <div class="card-footer">
                    <small class="text-muted">
                        Showing {{ $transactionsPaginator->count() }} of {{ $transactionsPaginator->total() }} results
                    </small>
                </div>
            </div>
        </div>
    </div>
@endsection