@extends('backend.layouts.master')

@section('title', 'Edit Accessory')

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Edit Accessory</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accesories.list') }}">Accessories</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Edit Accessory</h3>
            </div>

            <form action="{{ route('accesories.update', $accessory->id) }}" method="POST">
                @csrf
                @method('PUT') <!-- This tells Laravel you're updating the resource -->
                <div class="card-body">
                    {{-- Name Field --}}
                    <div class="form-group">
                        <label for="name">Accessory Name</label>
                        <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror"
                            value="{{ old('name', $accessory->name) }}" placeholder="Enter accessory name" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Unit Field --}}
                    <div class="form-group">
                        <label for="unit">Unit</label>
                        <input type="text" name="unit" id="unit" class="form-control @error('unit') is-invalid @enderror"
                            value="{{ old('unit', $accessory->unit) }}" placeholder="Enter unit (e.g., pcs, meter)" required>
                        @error('unit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                     <div class="col-md-12 mb-3">
                                <label for="validationCustom01">Branch Name * :

                                  
                                </label>
                                <select class="form-control select2" name="branch_id">
                                    <option selected disabled value="">--Select--</option>
                                   @if(auth()->user()->role_id > 1)
                                    @foreach ($branchs as $key => $value)
                                        <option value="{{ $value->id }}" {{auth()->user()->branch_id == $value->id ? 'selected' :''}}>{{ $value->name }}</option>
                                    @endforeach
                                    @else 

                                @foreach ($branchs as $key => $value)
                                        <option value="{{ $value->id }}">{{ $value->name }}</option>
                                    @endforeach
                                    @endif
                                </select>
                                @error('name')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="{{ route('accesories.list') }}" class="btn btn-secondary">Back to List</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
