<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuickPurchasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quick_purchases', function (Blueprint $table) {
            $table->id();
            $table->date('date')->nullable();
            $table->foreignId('ledger_id')->nullable();
            $table->foreignId('branch_id')->nullable();
            $table->decimal('total_amount', 10, 2)->nullable();
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('shipping_charge', 10, 2)->default(0);
            $table->decimal('received_amount', 10, 2)->default(0);
            $table->decimal('due_balance', 10, 2)->default(0);
            $table->enum('payment_status', ['due', 'partial', 'paid'])->default('due');
            $table->enum('delivery_status', ['Pending', 'Confirm', 'Pick-up', 'On The Way', 'Delivered', 'Cancel'])->default('Pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quick_purchases');
    }
}
