<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDabitVoucherDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dabit_voucher_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dabit_voucher_id');
            $table->foreignId('branch_id')->nullable();
            $table->foreignId('account_id');
            $table->string('code')->nullable();
            $table->float('amount', 12, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dabit_voucher_details');
    }
}
