<?php

namespace App\Services\InventorySetup;

use App\Repositories\InventorySetup\GoodsRepositories;
use App\Rules\PhoneNumberValidationRules;
use Illuminate\Support\Facades\Validator;

class GoodsService
{

    /**
     * @var GoodsRepositories
     */
    private $systemRepositories;
    /**
     * AdminCourseService constructor.
     * @param GoodsRepositories $branchRepositories
     */
    public function __construct(GoodsRepositories $systemRepositories)
    {
        $this->systemRepositories = $systemRepositories;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        return $this->systemRepositories->getList($request);
    }
    /**
     
    /**
     * @param $request
     * @return mixed
     */
    public function statusUpdate($request, $id)
    {
        return $this->systemRepositories->statusUpdate($request, $id);
    }

    public function statusValidation($request)
    {
        return [
            'id'                   => 'required',
            'status'               => 'required',
        ];
    }
    /**
     * @param $request
     * @return array
     */
    public function storeValidation($request)
    {
        return [
            'name'                   => 'required|max:100',
            'genre_id'               => 'required',
            // 'unit_id'                => 'required',
        ];
    }

    /**
     * @param $id
     * @return array
     */
    public function updateValidation($request, $id)
    {
        return [
            'name'                   => 'required|max:100',
            'genre_id'               => 'required',
            // 'unit_id'                => 'required',
        ];
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function store($request)
    {
        return $this->systemRepositories->store($request);
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function details($id)
    {

        return $this->systemRepositories->details($id);
    }


    /**
     * @param $request
     * @param $id
     */
    public function update($request, $id)
    {
        return $this->systemRepositories->update($request, $id);
    }




    /**
     * @param $request
     * @param $id
     */
    public function destroy($id)
    {
        return $this->systemRepositories->destroy($id);
    }

    /**
     * Delete the thumbnail of a product.
     *
     * @param int $id The ID of the product whose thumbnail is to be deleted.
     * @return bool True if the thumbnail was deleted successfully, false otherwise.
     */
    public function deleteThumbnail($id)
    {
        return $this->systemRepositories->deleteThumbnail($id);
    }
}
