<?php

namespace App\Repositories\Usermanage;

use App\Helpers\Helper;
use App\Models\RoleAccess;
use App\Models\Buyer;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class BuyerRepositories {
    
    /**
     * @var buyer_id
     */
    private $buyer_id;
    
    /**
     * @var buyer
     */
    private $buyer;
    
    /**
     * CourseRepository constructor.
     * @param buyer $buyer
     */
    
     public function __construct(Buyer $buyer) {
        $this->buyer = $buyer;
        //$this->middleware(function ($request, $next) {
        $this->buyer_id = 1; //auth()->buyer()->id;
        //  return $next($request);
        //});
    }
    
    /**
     * @param $request
     * @return mixed
     */

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request) {
        $columns = array(
            0 => 'id',
            1 => 'name',
            2 => 'email',
        );

        $edit = Helper::roleAccess('usermanage.buyer.edit') ? 1 : 1;
        $delete = Helper::roleAccess('usermanage.buyer.destroy') ? 1 : 1;
        $view = Helper::roleAccess('usermanage.buyer.show') ? 1 : 1;
        $ced = $edit + $delete + $view;

        $totalData = $this->buyer::count();
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $buyers = $this->buyer::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->buyer::count();
        } else {
            $search = $request->input('search.value');
            $buyers = $this->buyer::where('name', 'like', "%{$search}%")
                ->orWhere('email', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->buyer::where('name', 'like', "%{$search}%")
                ->count();
        }

        $data = array();
        if ($buyers) {
            foreach ($buyers as $key => $buyer) {
                $nestedData['id'] = $key + 1;
                $nestedData['name'] = $buyer->name;
                $nestedData['company_name'] = $buyer->company_name;
                $nestedData['email'] = $buyer->email;
                $nestedData['phone'] = $buyer->phone;
                if ($buyer->status == 'Approved') :
                    $status = '<input class="status_row" status_route="' . route('usermanage.buyer.status', [$buyer->id, 'Rejected']) . '"   id="toggle-demo" type="checkbox" name="my-checkbox" checked data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                else :
                    $status = '<input  class="status_row" status_route="' . route('usermanage.buyer.status', [$buyer->id, 'Approved']) . '"  id="toggle-demo" type="checkbox" name="my-checkbox"  data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                endif;
                $nestedData['status'] = $status;
                if ($ced != 0) :
                    if ($edit != 0) {
                        $edit_data = '<a href="' . route('usermanage.buyer.edit', $buyer->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    } else {
                        $edit_data = '';
                    }

                    if ($view != 0) {
                        $view_data = '<a href="' . route('usermanage.buyer.show', $buyer->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    } else {
                        $view_data = '';
                    }

                    if ($delete != 0) {
                        $delete_data = '<a delete_route="' . route('usermanage.buyer.destroy', $buyer->id) . '" delete_id="' . $buyer->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $buyer->id . '"><i class="fa fa-times"></i></a>';
                    } else {
                        $delete_data = '';
                    }

                    $nestedData['action'] = $edit_data . ' ' . $delete_data . ' ' . $view_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data,
        );

        return $json_data;
    }
    /**
     * @param $request
     * @return mixed
     */
    public function details($id)
    {
        $result = $this->buyer::find($id);
        return $result;
    }

    public function store($request) {

        // dd($request->all());

        $buyer = new $this->buyer();
        $buyer->name = $request->name;
        $buyer->company_name = $request->company_name;
        $buyer->phone = $request->phone;
        $buyer->email = $request->email;
        $buyer->password = Hash::make($request->password);
        $buyer->branch_id = $request->branch_id ?? null;
        // $buyer->avatar = $request->avatar;
        $buyer->address = $request->address;
        $buyer->status = $request->status;
        $buyer->save();

        return $buyer;
    }

    public function update($request, $id)
    {
        $buyer = $this->buyer::findOrFail($id);
        $buyer->name = $request->name;
        $buyer->company_name = $request->company_name;
        $buyer->phone = $request->phone;
        $buyer->email = $request->email;
        if($request->password){
            $buyer->password = Hash::make($request->password);
        }
        $buyer->branch_id = $request->branch_id ?? null;
        $buyer->address = $request->address;
        $buyer->status = $request->status;
        $buyer->save();

        return $buyer;
    }

    public function statusUpdate($id, $status)
    {
        $buyer = $this->buyer::find($id);
        $buyer->status = $status;
        $buyer->save();
        return $buyer;
    }

    public function destroy($id)
    {
        $buyer = $this->buyer::find($id);
        $buyer->delete();
        return true;
    }
}
