<?php

namespace App\Repositories\Order;

use App\Helpers\Helper;
use Illuminate\Support\Facades\Auth;
use App\Models\Status;
use phpDocumentor\Reflection\PseudoTypes\False_;

class StatusRepositories {
    /**
     * @var user_id
     */
    private $user_id;
    /**
     * @var Status
     */
    private $status;
    
    /**
     * CourseRepository constructor.
     * @param productUnit $productUnit
     */

    public function __construct(Status $status) {
        $this->status = $status;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }


    /**
     * @param $request
     * @return mixed
     */
    public function getAllList() {
        $result = $this->status::latest()->get();
        return $result;
    }
    /**
     * @param $request
     * @return mixed
     */

    public function getList($request) {
        $columns = array(
            0 => 'id',
            1 => 'name',
        );

        $edit = Helper::roleAccess('inventorySetup.unit.edit') ? 1 : 0;
        $delete = Helper::roleAccess('inventorySetup.unit.destroy') ? 1 : 0;
        $view = Helper::roleAccess('inventorySetup.unit.show') ? 0 : 0;
        $ced = $edit + $delete + $view;

        $totalData = $this->status::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $statuses = $this->status::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->status::count();
        } else {
            $search = $request->input('search.value');
            $statuses = $this->status::where('name', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->status::where('name', 'like', "%{$search}%")->count();
        }

        $data = array();
        if ($statuses) {
            foreach ($statuses as $key => $status) {
                $nestedData['id'] = $key + 1;
                $nestedData['title'] = $status->title;
                $nestedData['order'] = $status->order_by;
                if ($ced != 0) :
                    if ($edit != 0)
                        $edit_data = '<a href="' . route('order.status.edit', $status->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    else
                        $edit_data = '';
                    if ($view != 0)
                        $view_data = '<a href="' . route('order.status.show', $status->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    else
                        $view_data = '';
                    if ($delete != 0)
                        $delete_data = '<a delete_route="' . route('order.status.destroy', $status->id) . '" delete_id="' . $status->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $status->id . '"><i class="fa fa-times"></i></a>';
                    else
                        $delete_data = '';
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        return $json_data;
    }
    /**
     * @param $request
     * @return mixed
     */
    public function details($id) {
        $result = $this->status::find($id);
        return $result;
    }

    public function store($request) {
        $status = new $this->status();
        $status->title = $request->title;
        $status->order_by = $request->order_by;
        // $status->created_by = Auth::user()->id;
        $status->save();
        return $status;
    }

    public function update($request, $id) {
        $status = $this->status::findOrFail($id);
        $status->title = $request->title;
        $status->order_by = $request->order_by;
        // $status->updated_by = Auth::user()->id;
        $status->save();
        return $status;
    }

    public function statusUpdate($id, $status) {
        $status = $this->status::find($id);
        $status->status = $status;
        $status->save();
        return $status;
    }

    public function destroy($id) {
        $status = $this->status::find($id);
        $status->delete();
        return true;
    }
}
