<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuickSalesProduct extends Model
{
    use HasFactory;

    protected $table = 'quick_sale_products';
    // Mass assignable attributes
    protected $fillable = [
        'sale_id',
        'product_name',
        'price',
        'quantity',
        'total_price',
        'productSpecification',
        'fabricSpecification',
        'fabric',

    ];

    /**
     * Define the relationship with OrderProduct.
     * One order can have many products.
     */

    public function quickSale()
    {
        return $this->belongsTo(QuickSales::class, 'sale_id', 'id');
    }
}
