<?php

namespace App\Http\Controllers\Auth\Buyer;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\Buyer;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller {
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Display registration form.
     *
     * @var string
     */
    public function index() {
        return view('frontant.buyer.register', get_defined_vars());
    }

    public function store(Request $resquest) {
        $validate = $resquest->validate([
            'name' => 'required|string|max:100|min:2',
            'email' => 'required|email|unique:buyers,email|max:100|min:2',
            'phone' => 'required|string|unique:buyers,phone|max:15|min:2',
            'password' => 'required|string|confirmed|min:6',
        ]);
        
        $buyer = Buyer::create($validate);
        $buyer->password = Hash::make($resquest->password);
        $buyer->status = 'Pending';
        $buyer->save();
        return redirect()->route('buyer.login');
    }

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::BUYER;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data) {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data) {
        return Buyer::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }
}
