@php
    $num = isset($countNum) ? $countNum + 1 : 0;
    $skip = $skip ?? [];
@endphp

@foreach ($setAccounts as $account)
    @if (in_array($account->id, $skip))
    @else
        @if ($account->subAccount->isNotEmpty())
            <x-card-account :setAccounts="$account->subAccount" :skip="$skip" :countNum="$num" />
        @else
            <div class="col-md-4">
                <div class="card text-white bg-info mb-3">
                    <div class="card-body">
                        <a
                            href="{{ route('report.cashbook.cashbook', [
                                'account_id' => $account->id,
                                'start_date' => date("Y-m-d"),
                                'end_date' =>  date("Y-m-d"),
                            ]) }}">
                            <h5 class="" style="color:black">{{ $account->account_name }} {{ $account->account_code }}
                                {{ $account->bank_name }}</h5>

                        <p class="card-text" style="color:rgb(252, 252, 252)">{{ getUnderAccount($account->unique_identifier, today()) }}</p>
                    </a>
                    </div>
                </div>
            </div>
        @endif
    @endif
@endforeach
