@php
    $num = isset($countNum) ? $countNum + 1 : 0;
    $selected = isset($selectVal) ? $selectVal : 0;
    $skip = $skip ?? [];
@endphp

@foreach ($setAccounts as $account)
    @if (in_array($account->id, $skip))
    @else
        @if ($account->subAccount->isNotEmpty())
            <x-account :setAccounts="$account->subAccount" :skip="$skip" :selectVal="$selected" :countNum="$num" />
        @else
            <option {{ $selected == $account->id ? 'selected' : '' }} value="{{ $account->id }}">
                {{ $account->account_name }} {{ $account->account_code }}  {{ $account->bank_name }}
                @if ($account->accountable_type && $account->accountable_id)
                {{ optional($account->accountable)->phone ?? 'N/A' }}
                @endif
            </option>
        @endif
    @endif
@endforeach
