@extends('backend.layouts.master')

@section('title', 'Create Stock Out')

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Create Stock Out</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('stockOut.list') }}">Stock Out</a></li>
                        <li class="breadcrumb-item active">Create</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('admin-content')
    <div class="row justify-content-center">
        <div class="col-md-11">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">New Stock Out</h3>
                </div>

                <form action="{{ route('stockOut.store') }}" method="POST" id="create-stockin-form">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            {{-- Accessory Name Field --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="accessory_name">Accessory Name</label>
                                    <select name="accessory_name" id="accessory_name"
                                        class="form-control @error('accessory_name') is-invalid @enderror" required>
                                        <option value="">Select Accessory</option>
                                        @foreach (App\Models\Accesories::all() as $accessory)
                                            @php
                                                $stock = \App\Models\stockinsummary::where(
                                                    'product_id',
                                                    $accessory->id,
                                                )->sum('quantity');

                                            @endphp
                                            <option value="{{ $accessory->name }}" data-id="{{ $accessory->id }}"
                                                data-unit="{{ $accessory->unit }}" data-stock="{{ $stock }}">
                                                {{ $accessory->name }}(Stock: {{ $stock }})
                                            </option>
                                        @endforeach

                                    </select>
                                    @error('accessory_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Unit Field --}}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="unit">Unit</label>
                                    <input type="text" name="unit" id="unit"
                                        class="form-control @error('unit') is-invalid @enderror"
                                        value="{{ old('unit') }}" placeholder="Unit will be auto-filled" readonly
                                        required>
                                    @error('unit')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Append Button (with Plus Icon) --}}
                            <div class="col-md-2 d-flex align-items-end mb-3 ">
                                <button type="button" id="append-fields" class="btn btn-secondary w-100 p-2">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>

                        {{-- Dynamic Fields Container --}}
                        <div id="additional-fields-container" class="mt-3"></div>
                    </div>


                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Create</button>
                        <a href="{{ route('stockOut.list') }}" class="btn btn-secondary">Back to List</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // Populate unit field when accessory is selected
        $('#accessory_name').on('change', function() {
            let unit = $(this).find(':selected').data('unit');
            $('#unit').val(unit ?? '');
        });

        let rowCount = 0;

        $('#append-fields').on('click', function() {
            let selected = $('#accessory_name').find(':selected');
            let accessoryName = selected.val();
            let accessoryId = selected.data('id');
            let unit = selected.data('unit');
            let stock = selected.data('stock');

            if (accessoryName && unit) {
                rowCount++;
                let newFields = `
                <div class="row dynamic-row" id="row-${rowCount}">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description[]" class="form-control" rows="3" placeholder="Enter description" ></textarea>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>In Quantity</label>
                            <input type="number" name="in_quantity[]" class="form-control" placeholder="Enter quantity" max="${stock}" required>
                            <small class="text-muted">Available: ${stock}</small>
                        </div>
                    </div>

                    <div class="col-md-3 d-none">
                        <div class="form-group">
                            <label for="price">Price</label>
                            <input type="number" step="0.01" min="0" name="price[]" class="form-control" placeholder="Enter price" value="0">
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Accessory Name</label>
                            <input type="hidden" name="accessory_id[]" value="${accessoryId}">
                            <input type="text" class="form-control" value="${accessoryName}" readonly>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Unit</label>
                            <input type="text" class="form-control" value="${unit}" readonly>
                        </div>
                    </div>
                    <div class="col-md-3 d-none">
                        <div class="form-group">
                            <label for="kg">KG</label>
                            <input type="number" name="kg[]" class="form-control" placeholder="Enter kg">
                        </div>
                    </div>
                    <div class="col-md-3 d-none">
                        <div class="form-group">
                            <label for="total_price">Total Price</label>
                            <input type="number" name="total_price[]" class="form-control" value="0">
                        </div>
                    </div>
                    <div class="col-md-2 align-self-end mb-3">
                        <button type="button" class="btn btn-danger remove-row" data-row-id="row-${rowCount}">
                            <i class="fa fa-trash"></i> Remove
                        </button>
                    </div>
                </div>`;
                $('#additional-fields-container').append(newFields);

                // Handle price and quantity input to update total price
                $('#additional-fields-container').on('input', 'input[name="price[]"], input[name="in_quantity[]"]', function() {
                    var $row = $(this).closest('.dynamic-row');
                    var price = parseFloat($row.find('input[name="price[]"]').val()) || 0;
                    var quantity = parseInt($row.find('input[name="in_quantity[]"]').val()) || 0;
                    var total = price * quantity;
                    $row.find('input[name="total_price[]"]').val(total.toFixed(2)); // Format total price to 2 decimals
                });

                // Optional: Auto format price field to two decimals when losing focus
                $(document).on('blur', 'input[name="price[]"]', function() {
                    var priceVal = parseFloat($(this).val()) || 0;
                    $(this).val(priceVal.toFixed(2)); // Format to 2 decimals
                });
            } else {
                alert('Please select an accessory before appending fields.');
            }
        });

        // Move this outside of the click event so it's not re-bound each time
        $(document).on('input', 'input[name="in_quantity[]"]', function() {
            const max = parseInt($(this).attr('max'));
            const val = parseInt($(this).val());

            if (val > max) {
                alert('Quantity exceeds available stock!');
                $(this).val('');
            }
        });

        // Remove row functionality
        $(document).on('click', '.remove-row', function() {
            const rowId = $(this).data('row-id');
            $('#' + rowId).remove();
        });
    });
</script>

@push('scripts')
@endpush
