@extends('backend.layouts.master')

@section('title', 'Accessories List')

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
</style>
@endsection

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6"></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    @if (helper::roleAccess('sale.sale.index'))
                        <li class="breadcrumb-item"><a href="{{ route('stockin.list') }}">Accessories</a></li>
                    @endif
                    <li class="breadcrumb-item active">Stock In List</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="p-2 d-flex justify-content-between">
                <h3 class="card-title">Stock in List</h3>
                <div class="card-tools">
                    @if (helper::roleAccess('sale.sale.create'))
                        <a class="btn btn-default" href="{{ route('stockin.create') }}">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                    @endif
                    <span id="buttons"></span>
                    <button class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="systemDatatables" class="display table-hover table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($stockIn as $sale)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $sale->created_at ? $sale->created_at->format('d-F-Y h:i A') : 'N/A' }}</td>

                                    <td>
                                        <!-- Edit Button -->
                                        <a href="{{ route('stockin.edit', $sale->id) }}" class="btn btn-primary btn-sm ml-2">
                                            <i class="bi bi-pencil"></i> Edit
                                        </a>

                                        <!-- Show Button -->
                                        <a href="{{ route('stockin.show', $sale->id) }}" class="btn btn-info btn-sm ml-2">
                                            <i class="bi bi-eye"></i> Show
                                        </a>

                                        <!-- Delete Form -->
                                        {{-- <form action="{{ route('stockIn.delete', $sale->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm ml-2">
                                                <i class="bi bi-trash"></i> Delete
                                            </button>
                                        </form> --}}
                                    </td>

                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>SL</th>
                                <th>Date</th><!-- Footer for stock -->
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                {{-- Optional footer --}}
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')

@endsection
