@extends('backend.layouts.master')

@section('title', 'Create Stock In')

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Create Stock In</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('stockin.list') }}">Stock In</a></li>
                        <li class="breadcrumb-item active">Create</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('admin-content')
    <div class="row justify-content-center">
        <div class="col-md-11">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">New Stock In</h3>
                </div>
                <form action="{{ route('stockin.store') }}" method="POST" id="create-stockin-form">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            @php
                                $ledgers = App\Models\ChartOfAccount::where('parent_id',16)->get();
                            @endphp
                              <div class="col-md-12 mb-3">
                                <label for="ledger_id">Ledger * :
                                    <button type="button" class="btn btn-sm btn-primary ml-2" data-toggle="modal"
                                        data-target="#addSupplierModal">
                                        +
                                    </button>
                                </label>
                                <select class="form-control select2 supid" name="ledger_id" id="ledger_id">
                                    <option selected disabled value="">--Select Ledger--</option>
                                    <x-account :setAccounts="$ledgers" />
                                </select>
                                @error('ledger_id')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- Accessory Name Field --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="accessory_name">Accessory Name</label>
                                    <select name="accessory_name" id="accessory_name"
                                        class="form-control @error('accessory_name') is-invalid @enderror" required>
                                        <option value="">Select Accessory</option>
                                        @foreach (App\Models\Accesories::all() as $accessory)
                                            <option value="{{ $accessory->name }}" data-id="{{ $accessory->id }}"
                                                data-unit="{{ $accessory->unit }}">
                                                {{ $accessory->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('accessory_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Unit Field --}}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="unit">Unit</label>
                                    <input type="text" name="unit" id="unit"
                                        class="form-control @error('unit') is-invalid @enderror" value="{{ old('unit') }}"
                                        placeholder="Unit will be auto-filled" readonly required>
                                    @error('unit')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            {{-- Append Button (with Plus Icon) --}}
                            <div class="col-md-2 d-flex align-items-end mb-3 ">
                                <button type="button" id="append-fields" class="btn btn-secondary w-100 p-2">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>

                        {{-- Dynamic Fields Container --}}
                        <div id="additional-fields-container" class="mt-3"></div>
                    </div>
<div class="row">
    <div class="col-md-6 ml-auto">
        <label for="delivery_cost">Delivery Cost</label>
        <input type="number" id="delivery_cost" name="delivery_cost" class="form-control" placeholder="Enter delivery cost" step="0.01" min="0" />
    </div>
</div>







                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Create</button>
                        <a href="{{ route('stockin.list') }}" class="btn btn-secondary">Back to List</a>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="addSupplierModal" tabindex="-1" role="dialog" aria-labelledby="addSupplierModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addSupplierModalLabel">Add Supplier</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" id="addSupplierForm"
                    action="{{ route('inventorySetup.purchase.supplierCreate') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="validationCustom01">Supplier Name * :</label>
                            <input type="text" name="name" class="form-control" id="validationCustom01"
                                placeholder="Supplier Name" value="{{ old('name') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="validationCustom02"> E-mail :</label>
                            <input type="text" name="email" class="form-control" id="validationCustom02"
                                placeholder="E-mail" value="{{ old('email') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="validationCustom01">Phone * :</label>
                            <input type="text" name="phone" class="form-control" id="validationCustom01"
                                placeholder="Phone" value="{{ old('phone') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="validationCustom01">BIN :</label>
                            <input type="text" name="specialNumber" class="form-control" id="validationCustom01"
                                placeholder="BIN Number" value="{{ old('specialNumber') }}">
                        </div>
                        <div class="form-group">
                            <label for="validationCustom02">Address :</label>
                            <input name="address" class="form-control" id="validationCustom02" placeholder="Address"
                                value="{{ old('address') }}" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save Supplier</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {

             $(document).ready(function() {
            // Supplier  Create
            $('#addSupplierForm').on('submit', function(e) {
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: $(this).attr('action'),
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            $('#addSupplierModal').modal('hide');
                            $('select[name="ledger_id"]').append(
                                `<option value="${response.accounts.id}" selected>${response.accounts.account_name}</option>`
                            );
                        } else {
                            alert('Error adding Unit');
                        }
                    },
                    error: function(error) {
                        alert('An error occurred');
                    }
                });
                $("button[type='submit']").prop('disabled', false);
            });
        });
        // Handle accessory selection and populate unit field using AJAX
        $('#accessory_name').on('change', function() {
            var accessoryName = $(this).val(); // Get the selected accessory name
            var accessoryId = $(this).find(':selected').data('id'); // Get the selected accessory ID
            var unit = $(this).find(':selected').data('unit'); // Get the selected accessory unit

            if (accessoryName) {
                // Populate the unit field
                $('#unit').val(unit);
            } else {
                $('#unit').val(''); // Clear the unit if no accessory is selected
            }
        });

        // Handle append button click to add fields dynamically
        let rowCount = 0; // Counter for unique IDs

        $('#append-fields').on('click', function() {
            var accessoryName = $('#accessory_name').val();
            var accessoryId = $('#accessory_name').find(':selected').data('id'); // Get the selected accessory ID
            var unit = $('#unit').val();

            if (accessoryName && unit) {
                rowCount++; // Increment counter for unique IDs
                var newFields = `
                    <div class="row dynamic-row" style="border: 1px solid; margin-bottom: 2px;" id="row-${rowCount}">
                      <div class="col-md-3">
                            <div class="form-group">
                                <label for="accessory_id">Accessory Name</label>
                                <input type="hidden" name="accessory_id[]" value="${accessoryId}">
                                <input type="text" class="form-control" value="${accessoryName}" readonly>
                            </div>
                        </div>
                           <div class="col-md-3">
                            <div class="form-group">
                                <label for="unit">Unit</label>
                                <input type="text" class="form-control" value="${unit}" readonly>
                            </div>
                        </div>


                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="in_quantity">In Quantity</label>
                                <input type="number" name="in_quantity[]" class="form-control" placeholder="Enter quantity" required>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="price">Price</label>
                                <input type="number" step="0.01" min="0" name="price[]" class="form-control" placeholder="Enter price" required>
                            </div>
                        </div>



                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="kg">KG</label>
                                <input type="number" name="kg[]" class="form-control" placeholder="Enter kg">
                            </div>
                        </div>
                          <div class="col-md-3">
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea name="description[]" class="form-control" rows="1" placeholder="Enter description" ></textarea>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="total_price">Total Price</label>
                                <input type="number" name="total_price[]" class="form-control" readonly>
                            </div>
                        </div>
                        <div class="col-md-2 align-self-end mb-3">
                            <button type="button" class="btn btn-danger remove-row" data-row-id="row-${rowCount}">
                                <i class="fa fa-trash"></i> Remove
                            </button>
                        </div>
                    </div>
                `;
                $('#additional-fields-container').append(newFields);

                // Handle price and quantity input to update total price
                $('#additional-fields-container').on('input', 'input[name="price[]"], input[name="in_quantity[]"]', function() {
                    var $row = $(this).closest('.dynamic-row');
                    var price = parseFloat($row.find('input[name="price[]"]').val()) || 0;
                    var quantity = parseInt($row.find('input[name="in_quantity[]"]').val()) || 0;
                    var total = price * quantity;
                    $row.find('input[name="total_price[]"]').val(total.toFixed(2)); // Format total price to 2 decimals
                });

                // Optional: Auto format price field to two decimals when losing focus
                $(document).on('blur', 'input[name="price[]"]', function() {
                    var priceVal = parseFloat($(this).val()) || 0;
                    $(this).val(priceVal.toFixed(2)); // Format to 2 decimals
                });
            } else {
                alert('Please select an accessory and unit before appending fields.');
            }
        });

        // Handle removal of appended rows
        $(document).on('click', '.remove-row', function() {
            var rowId = $(this).data('row-id');
            $('#' + rowId).remove();
        });
    });
</script>

@push('scripts')
@endpush
