@extends('backend.layouts.master')

@section('title')
    Report - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
    <!-- Include Date Range Picker CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Report</h1>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <form id="reportSearchForm" method="POST">
                @csrf
                <div class="card card-outline card-info no-print">
                    <div class="card-body">
                        <div class="row no-print">
                            <div class="box-header with-border" style="cursor: pointer;">
                                <h6 class="box-title">
                                    <i class="fa fa-filter" aria-hidden="true"></i> Filters
                                </h6>
                            </div>
                        </div>

                        <div class="row no-print">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Date Range:</label>
                                    <input type="text" class="form-control" name="dateRange" id="reservation" autocomplete="off" />
                                    @error('dateRange')
                                        <span class="error text-red text-bold"> {{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Branch</label>
                                    @php
                                        $branches = App\Models\Branch::all();
                                    @endphp
                                    <select class="form-control select2" name="branch_id" id="branch_id">
                                        <option selected disabled value="">--Select Branch--</option>
                                        @foreach ($branches as $branch)
                                            <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('branch_id')
                                        <span class="error text-red text-bold"> {{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label><br>
                                    <button type="button" class="btn btn-sm btn-success search-btn">
                                        <i class="fa fa-search"></i> Search
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="load_data"></div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <!-- Include jQuery and Date Range Picker -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize Date Range Picker
            $('#reservation').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'YYYY-MM-DD',
                    cancelLabel: 'Clear'
                }
            });

            $('#reservation').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));
            });

            $('#reservation').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });

            // AJAX Search
            $(".search-btn").on("click", function(e) {
                e.preventDefault();

                let dateRange = $("#reservation").val();
                let branch_id = $("#branch_id").val();

                $.ajax({
                    url: "{{ route('report.sale.search') }}",
                    type: "GET",
                    data: {
                        dateRange: dateRange,
                        branch_id: branch_id,
                    },
                    beforeSend: function() {
                        $("#load_data").html('<div class="text-center">Loading...</div>');
                    },
                    success: function(response) {
                        $("#load_data").html(response);
                    },
                    error: function(xhr) {
                        console.log(xhr.responseText);
                        alert("Something went wrong!");
                    }
                });
            });
        });
    </script>
@endsection
